/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareClassLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.codehaus.groovy.grails.exceptions.CompilationFailedException;

public class GrailsClassLoader
extends GroovyClassLoader {
    private ClassLoader parent;
    private GrailsResourceLoader grailsResourceLoader;
    private Map innerClassLoaderMap = new HashMap();

    public GrailsClassLoader(ClassLoader parent, CompilerConfiguration config, GrailsResourceLoader resourceLoader) {
        super(parent, config);
        this.parent = parent;
        this.grailsResourceLoader = resourceLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class reloadClass(String name) {
        try {
            URL resourceURL = this.grailsResourceLoader.loadGroovySource(name);
            GrailsAwareClassLoader innerLoader = new GrailsAwareClassLoader(this.parent);
            InputStream inputStream = null;
            try {
                inputStream = resourceURL.openStream();
                Class reloadedClass = innerLoader.parseClass(inputStream, name);
                this.innerClassLoaderMap.put(name, innerLoader);
                Class clazz = reloadedClass;
                return clazz;
            }
            catch (IOException e) {
                throw new CompilationFailedException("Error opening stream to class " + name + " with URL " + resourceURL, e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        catch (MalformedURLException e) {
            throw new CompilationFailedException("Error opening stream to class " + name + ":" + e.getMessage(), e);
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        GroovyClassLoader innerLoader = (GroovyClassLoader)this.innerClassLoaderMap.get(name);
        if (innerLoader != null) {
            return innerLoader.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    public void setGrailsResourceLoader(GrailsResourceLoader resourceLoader) {
        this.grailsResourceLoader = resourceLoader;
    }
}

