/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.InjectableGrailsClass;

public class DefaultArtefactInfo
implements ArtefactInfo {
    private GrailsClass[] grailsClasses;
    private Class[] classes;
    private Map grailsClassesByName = new HashMap();
    private Map classesByName = new HashMap();
    private Map logicalPropertyNameToClassMap = new HashMap();
    public Map handlerData = new HashMap();

    public synchronized void addGrailsClass(GrailsClass artefactClass) {
        this.grailsClassesByName = new HashMap(this.grailsClassesByName);
        this.classesByName = new HashMap(this.classesByName);
        Class actualClass = artefactClass.getClazz();
        boolean addToGrailsClasses = true;
        if (artefactClass instanceof InjectableGrailsClass) {
            addToGrailsClasses = ((InjectableGrailsClass)artefactClass).getAvailable();
        }
        if (addToGrailsClasses) {
            this.grailsClassesByName.put(actualClass.getName(), artefactClass);
        }
        this.classesByName.put(actualClass.getName(), actualClass);
        this.logicalPropertyNameToClassMap.put(artefactClass.getLogicalPropertyName(), artefactClass);
    }

    public synchronized void updateComplete() {
        this.grailsClassesByName = Collections.unmodifiableMap(this.grailsClassesByName);
        this.classesByName = Collections.unmodifiableMap(this.classesByName);
        this.grailsClasses = this.grailsClassesByName.values().toArray(new GrailsClass[this.grailsClassesByName.size()]);
        this.classes = this.classesByName.values().toArray(new Class[this.classesByName.size()]);
    }

    public Class[] getClasses() {
        return this.classes;
    }

    public GrailsClass[] getGrailsClasses() {
        return this.grailsClasses;
    }

    public Map getClassesByName() {
        return this.classesByName;
    }

    public Map getGrailsClassesByName() {
        return this.grailsClassesByName;
    }

    public synchronized GrailsClass getGrailsClass(String name) {
        return (GrailsClass)this.grailsClassesByName.get(name);
    }

    public synchronized GrailsClass getGrailsClassByLogicalPropertyName(String logicalName) {
        return (GrailsClass)this.logicalPropertyNameToClassMap.get(logicalName);
    }
}

