/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.io.support;

import groovy.util.ConfigObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.io.support.DefaultResourceLoader;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.grails.io.support.UrlResource;

public class GrailsResourceUtils {
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final String FOLDER_SEPARATOR = "/";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    public static final String WEB_INF = "/WEB-INF";
    public static final String GRAILS_APP_DIR = "grails-app";
    public static final String WEB_APP_DIR = "web-app";
    public static final String VIEWS_DIR_PATH = "grails-app/views/";
    public static final String REGEX_FILE_SEPARATOR = "[\\\\/]";
    public static Pattern DOMAIN_PATH_PATTERN = Pattern.compile(".+[\\\\/]grails-app[\\\\/]domain[\\\\/](.+)\\.(groovy|java)");
    public static Pattern RESOURCE_PATH_PATTERN = Pattern.compile(".+?[\\\\/]grails-app[\\\\/](.+?)[\\\\/](.+?\\.(groovy|java))");
    public static Pattern SPRING_SCRIPTS_PATH_PATTERN = Pattern.compile(".+?[\\\\/]grails-app[\\\\/]conf[\\\\/]spring[\\\\/](.+?\\.groovy)");
    public static Pattern[] COMPILER_ROOT_PATTERNS = new Pattern[]{SPRING_SCRIPTS_PATH_PATTERN, RESOURCE_PATH_PATTERN};
    public static final Pattern GRAILS_RESOURCE_PATTERN_FIRST_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_SECOND_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_THIRD_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_FOURTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_FIFTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_SIXTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_SEVENTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_EIGHTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_NINTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_TENTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_ELEVENTH_MATCH;
    public static final Pattern[] patterns;
    private static final Log LOG;
    private static final Pattern PLUGIN_PATTERN;
    private static final Pattern PLUGIN_RESOURCE_PATTERN;

    private static String createGrailsResourcePattern(String separator, String base) {
        return ".+" + separator + base + separator + "(.+)\\.(groovy|java)$";
    }

    public static boolean isDomainClass(URL url) {
        if (url == null) {
            return false;
        }
        return DOMAIN_PATH_PATTERN.matcher(url.getFile()).find();
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String classPackageAsResourcePath(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getName().startsWith("JNLP"));
    }

    public static String getClassName(Resource resource) {
        try {
            return GrailsResourceUtils.getClassName(resource.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getClassName(String path) {
        for (Pattern pattern : patterns) {
            Matcher m = pattern.matcher(path);
            if (!m.find()) continue;
            return m.group(1).replaceAll("[/\\\\]", CURRENT_PATH);
        }
        return null;
    }

    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUrl);
        }
        try {
            return new File(GrailsResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().contains(JAR_URL_SEPARATOR);
    }

    public static File getFile(URI resourceUri, String description) throws FileNotFoundException {
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUri);
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static File getFile(URI resourceUri) throws FileNotFoundException {
        return GrailsResourceUtils.getFile(resourceUri, "URI");
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return GrailsResourceUtils.toURI(url.toString());
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || protocol.startsWith(URL_PROTOCOL_VFS);
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = GrailsResourceUtils.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = GrailsResourceUtils.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + GrailsResourceUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    private static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return GrailsResourceUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    private static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (coll != null && coll.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    private static String[] delimitedListToStringArray(String str, String delimiter) {
        return GrailsResourceUtils.delimitedListToStringArray(str, delimiter, null);
    }

    private static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(GrailsResourceUtils.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(GrailsResourceUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(GrailsResourceUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return GrailsResourceUtils.toStringArray(result);
    }

    private static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    private static String deleteAny(String inString, String charsToDelete) {
        if (!GrailsResourceUtils.hasLength(inString) || !GrailsResourceUtils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String replace(String inString, String oldPattern, String newPattern) {
        if (!GrailsResourceUtils.hasLength(inString) || !GrailsResourceUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    private static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith(FOLDER_SEPARATOR)) {
                    jarFile = FOLDER_SEPARATOR + jarFile;
                }
                return new URL(FILE_URL_PREFIX + jarFile);
            }
        }
        return jarUrl;
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(GrailsResourceUtils.replace(location, " ", "%20"));
    }

    public static boolean isGrailsPath(String path) {
        for (Pattern pattern : patterns) {
            Matcher m = pattern.matcher(path);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean isGrailsResource(Resource r) {
        try {
            return GrailsResourceUtils.isGrailsPath(r.getURL().getFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Resource getViewsDir(Resource resource) {
        if (resource == null) {
            return null;
        }
        try {
            Resource appDir = GrailsResourceUtils.getAppDir(resource);
            return new UrlResource(appDir.getURL().toString() + "/views");
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading URL whilst resolving views dir from [" + resource + "]: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public static Resource getAppDir(Resource resource) {
        if (resource == null) {
            return null;
        }
        try {
            String url = resource.getURL().toString();
            int i = url.lastIndexOf(GRAILS_APP_DIR);
            if (i > -1) {
                url = url.substring(0, i + 10);
                return new UrlResource(url);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading URL whilst resolving app dir from [" + resource + "]: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public static String getRelativeInsideWebInf(Resource resource) {
        if (resource == null) {
            return null;
        }
        try {
            String url = resource.getURL().toString();
            int i = url.indexOf(WEB_INF);
            if (i > -1) {
                return url.substring(i);
            }
            Matcher m = PLUGIN_PATTERN.matcher(url);
            if (m.find()) {
                return WEB_INF + m.group(1);
            }
            i = url.lastIndexOf(GRAILS_APP_DIR);
            if (i > -1) {
                return "/WEB-INF/" + url.substring(i);
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading URL whilst resolving relative path within WEB-INF from [" + resource + "]: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
        return null;
    }

    public static String getStaticResourcePathForResource(Resource resource, String contextPath) {
        String url;
        if (contextPath == null) {
            contextPath = "";
        }
        if (resource == null) {
            return contextPath;
        }
        try {
            url = resource.getURL().toString();
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading URL whilst resolving static resource path from [" + resource + "]: " + e.getMessage()), (Throwable)e);
            }
            return contextPath;
        }
        Matcher m = PLUGIN_RESOURCE_PATTERN.matcher(url);
        if (m.find()) {
            return (contextPath.length() > 0 ? contextPath + FOLDER_SEPARATOR : "") + m.group(1);
        }
        return contextPath;
    }

    public static String getPathFromRoot(String path) {
        for (Pattern COMPILER_ROOT_PATTERN : COMPILER_ROOT_PATTERNS) {
            Matcher m = COMPILER_ROOT_PATTERN.matcher(path);
            if (!m.find()) continue;
            return m.group(m.groupCount() - 1);
        }
        return null;
    }

    public static String getArtefactDirectory(String path) {
        Matcher matcher;
        if (path != null && (matcher = RESOURCE_PATH_PATTERN.matcher(path)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String appendPiecesForUri(String ... pieces) {
        if (pieces == null || pieces.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(16 * pieces.length);
        int previous = 0;
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i];
            if (piece == null || piece.length() <= 0) continue;
            int maxlen = piece.length();
            for (int j = 0; j < maxlen; ++j) {
                char current = piece.charAt(j);
                if (previous == 47 && current == '/') continue;
                builder.append(current);
                previous = current;
            }
            if (i + 1 >= pieces.length || previous == 47) continue;
            builder.append('/');
            previous = 47;
        }
        return builder.toString();
    }

    public static Object instantiateFromConfig(ConfigObject config, String configKey, String defaultClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LinkageError {
        return GrailsResourceUtils.instantiateFromFlatConfig(config.flatten(), configKey, defaultClassName);
    }

    public static Object instantiateFromFlatConfig(Map<String, Object> flatConfig, String configKey, String defaultClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LinkageError {
        String className = defaultClassName;
        Object configName = flatConfig.get(configKey);
        if (configName instanceof CharSequence) {
            className = configName.toString();
        }
        return GrailsResourceUtils.forName(className, DefaultResourceLoader.getDefaultClassLoader()).newInstance();
    }

    private static Class<?> forName(String className, ClassLoader defaultClassLoader) throws ClassNotFoundException {
        return defaultClassLoader.loadClass(className);
    }

    static {
        String fs = REGEX_FILE_SEPARATOR;
        GRAILS_RESOURCE_PATTERN_FIRST_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "conf" + fs + "spring"));
        GRAILS_RESOURCE_PATTERN_THIRD_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "[\\w-]+"));
        GRAILS_RESOURCE_PATTERN_SEVENTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "src" + fs + "java"));
        GRAILS_RESOURCE_PATTERN_EIGHTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "src" + fs + "groovy"));
        GRAILS_RESOURCE_PATTERN_NINTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "test" + fs + "unit"));
        GRAILS_RESOURCE_PATTERN_TENTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "test" + fs + "integration"));
        GRAILS_RESOURCE_PATTERN_ELEVENTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "test" + fs + "functional"));
        GRAILS_RESOURCE_PATTERN_FIFTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "grails-tests"));
        fs = FOLDER_SEPARATOR;
        GRAILS_RESOURCE_PATTERN_SECOND_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "conf" + fs + "spring"));
        GRAILS_RESOURCE_PATTERN_FOURTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "[\\w-]+"));
        GRAILS_RESOURCE_PATTERN_SIXTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "grails-tests"));
        patterns = new Pattern[]{GRAILS_RESOURCE_PATTERN_FIRST_MATCH, GRAILS_RESOURCE_PATTERN_SECOND_MATCH, GRAILS_RESOURCE_PATTERN_THIRD_MATCH, GRAILS_RESOURCE_PATTERN_SEVENTH_MATCH, GRAILS_RESOURCE_PATTERN_EIGHTH_MATCH, GRAILS_RESOURCE_PATTERN_FOURTH_MATCH, GRAILS_RESOURCE_PATTERN_FIFTH_MATCH, GRAILS_RESOURCE_PATTERN_SIXTH_MATCH, GRAILS_RESOURCE_PATTERN_NINTH_MATCH, GRAILS_RESOURCE_PATTERN_TENTH_MATCH, GRAILS_RESOURCE_PATTERN_ELEVENTH_MATCH};
        LOG = LogFactory.getLog(GrailsResourceUtils.class);
        PLUGIN_PATTERN = Pattern.compile(".+?(/plugins/.+?/grails-app/.+)");
        PLUGIN_RESOURCE_PATTERN = Pattern.compile(".+?/(plugins/.+?)/grails-app/.+");
    }
}

