/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.support;

import grails.util.BuildSettings;
import grails.util.GrailsNameUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPathDiscoverySupport {
    BuildSettings settings;

    public PluginPathDiscoverySupport(BuildSettings settings) {
        this.settings = settings;
    }

    public List<File> listKnownPluginDirs() {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.addAll(this.settings.getPluginDirectories());
        return dirs;
    }

    public List<File> listJarsInPluginLibs() {
        ArrayList<File> jars = new ArrayList<File>();
        List<File> pluginDirs = this.listKnownPluginDirs();
        for (File pluginDir : pluginDirs) {
            File[] files;
            File libDir;
            if (!pluginDir.exists() || !(libDir = new File(pluginDir, "lib")).exists() || (files = libDir.listFiles(new FilenameFilter(){

                public boolean accept(File file, String s) {
                    return s.endsWith(".jar");
                }
            })) == null || files.length <= 0) continue;
            jars.addAll(Arrays.asList(files));
        }
        return jars;
    }

    public String getPluginName(File pluginDir) {
        File desc = this.getPluginDescriptor(pluginDir);
        if (desc == null) {
            throw new RuntimeException("Cannot find plugin descriptor in plugin directory '" + pluginDir + "'.");
        }
        return GrailsNameUtils.getPluginName(desc.getName());
    }

    public File getPluginDescriptor(File dir) {
        if (!dir.exists()) {
            return null;
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                return s.endsWith("GrailsPlugin.groovy");
            }
        });
        return files.length > 0 ? files[0] : null;
    }
}

