/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.support;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import grails.util.GrailsNameUtils;
import groovy.lang.Closure;
import groovy.util.AntBuilder;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.LogLevel;
import org.codehaus.gant.GantBinding;
import org.codehaus.groovy.grails.cli.api.BaseSettingsApi;
import org.codehaus.groovy.grails.cli.logging.GrailsConsoleAntBuilder;
import org.codehaus.groovy.grails.cli.logging.GrailsConsoleBuildListener;
import org.codehaus.groovy.grails.cli.parsing.CommandLine;
import org.codehaus.groovy.grails.cli.support.PluginPathDiscoverySupport;
import org.codehaus.groovy.runtime.MethodClosure;
import org.springframework.util.ReflectionUtils;

public class ScriptBindingInitializer {
    private static final Pattern pluginDescriptorPattern = Pattern.compile("^(\\S+)GrailsPlugin.groovy$");
    private BuildSettings settings;
    private PluginPathDiscoverySupport pluginPathSupport;
    private boolean isInteractive;
    private CommandLine commandLine;

    public ScriptBindingInitializer(CommandLine commandLine, BuildSettings settings, PluginPathDiscoverySupport pluginPathSupport, boolean interactive) {
        this.commandLine = commandLine;
        this.settings = settings;
        this.pluginPathSupport = pluginPathSupport;
        this.isInteractive = interactive;
    }

    public GantBinding initBinding(GantBinding binding, String scriptName) {
        Closure c = this.settings.getGrailsScriptClosure();
        c.setDelegate((Object)binding);
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>(this.commandLine.getUndeclaredOptions());
        argsMap.put("params", this.commandLine.getRemainingArgs());
        binding.setVariable("argsMap", argsMap);
        binding.setVariable("args", (Object)this.commandLine.getRemainingArgsLineSeparated());
        binding.setVariable("grailsScript", (Object)c);
        binding.setVariable("grailsConsole", (Object)GrailsConsole.getInstance());
        binding.setVariable("grailsSettings", (Object)this.settings);
        File basedir = this.settings.getBaseDir();
        String baseDirPath = basedir.getPath();
        binding.setVariable("basedir", (Object)baseDirPath);
        binding.setVariable("scaffoldDir", (Object)(baseDirPath + "/web-app/WEB-INF/templates/scaffolding"));
        binding.setVariable("baseFile", (Object)basedir);
        binding.setVariable("baseName", (Object)basedir.getName());
        binding.setVariable("grailsHome", this.settings.getGrailsHome() != null ? this.settings.getGrailsHome().getPath() : null);
        binding.setVariable("grailsVersion", (Object)this.settings.getGrailsVersion());
        binding.setVariable("userHome", (Object)this.settings.getUserHome());
        binding.setVariable("grailsEnv", (Object)this.settings.getGrailsEnv());
        binding.setVariable("defaultEnv", (Object)this.settings.getDefaultEnv());
        binding.setVariable("buildConfig", (Object)this.settings.getConfig());
        binding.setVariable("rootLoader", (Object)this.settings.getRootLoader());
        binding.setVariable("configFile", (Object)new File(baseDirPath + "/grails-app/conf/Config.groovy"));
        String grailsWork = this.settings.getGrailsWorkDir().getPath();
        binding.setVariable("grailsWorkDir", (Object)grailsWork);
        binding.setVariable("projectWorkDir", (Object)this.settings.getProjectWorkDir().getPath());
        binding.setVariable("projectTargetDir", (Object)this.settings.getProjectTargetDir());
        binding.setVariable("classesDir", (Object)this.settings.getClassesDir());
        binding.setVariable("pluginClassesDir", (Object)this.settings.getPluginClassesDir());
        binding.setVariable("grailsTmp", (Object)(grailsWork + "/tmp"));
        binding.setVariable("classesDirPath", (Object)this.settings.getClassesDir().getPath());
        binding.setVariable("pluginClassesDirPath", (Object)this.settings.getPluginClassesDir().getPath());
        binding.setVariable("testDirPath", (Object)this.settings.getTestClassesDir().getPath());
        String resourcesDir = this.settings.getResourcesDir().getPath();
        binding.setVariable("resourcesDirPath", (Object)resourcesDir);
        binding.setVariable("webXmlFile", (Object)this.settings.getWebXmlLocation());
        binding.setVariable("pluginsDirPath", (Object)this.settings.getProjectPluginsDir().getPath());
        binding.setVariable("globalPluginsDirPath", (Object)this.settings.getGlobalPluginsDir().getPath());
        binding.setVariable("Ant", binding.getVariable("ant"));
        BaseSettingsApi cla = new BaseSettingsApi(this.settings, this.isInteractive);
        if (scriptName.equals("RunApp")) {
            cla.enableUaa();
        }
        this.makeApiAvailableToScripts(binding, cla);
        this.makeApiAvailableToScripts(binding, cla.getPluginSettings());
        this.setUIListener(binding);
        try {
            ArrayList<File> descriptors = new ArrayList<File>();
            File desc = this.pluginPathSupport.getPluginDescriptor(basedir);
            if (desc != null) {
                descriptors.add(desc);
            }
            for (File dir : this.pluginPathSupport.listKnownPluginDirs()) {
                File pluginDescriptor = this.pluginPathSupport.getPluginDescriptor(dir);
                if (pluginDescriptor != null) {
                    descriptors.add(pluginDescriptor);
                    continue;
                }
                GrailsConsole.getInstance().log("Cannot find plugin descriptor for path '" + dir.getPath() + "'.");
            }
            for (File file : descriptors) {
                Matcher matcher = pluginDescriptorPattern.matcher(file.getName());
                matcher.find();
                String pluginName = GrailsNameUtils.getPropertyName(matcher.group(1));
                binding.setVariable(pluginName + "PluginDir", (Object)file.getParentFile());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return binding;
    }

    private void setUIListener(GantBinding binding) {
        AntBuilder ant = (AntBuilder)binding.getVariable("ant");
        Project project = ant.getProject();
        project.getBuildListeners().clear();
        GrailsConsoleAntBuilder.addGrailsConsoleBuildListener(project);
        GrailsConsole instance = GrailsConsole.getInstance();
        project.addBuildListener((BuildListener)new GrailsConsoleBuildListener(instance));
        if (!instance.isVerbose()) {
            for (Object buildListener : project.getBuildListeners()) {
                if (!(buildListener instanceof BuildLogger)) continue;
                ((BuildLogger)buildListener).setMessageOutputLevel(LogLevel.ERR.getLevel());
            }
        }
    }

    protected void makeApiAvailableToScripts(GantBinding binding, Object cla) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = cla.getClass().getDeclaredMethods()) {
            String name = method.getName();
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            binding.setVariable(name, (Object)new MethodClosure(cla, name));
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor pd : propertyDescriptors = Introspector.getBeanInfo(cla.getClass()).getPropertyDescriptors()) {
                Method readMethod = pd.getReadMethod();
                if (readMethod == null || !this.isDeclared(cla, readMethod)) continue;
                binding.setVariable(pd.getName(), ReflectionUtils.invokeMethod((Method)readMethod, (Object)cla));
            }
        }
        catch (IntrospectionException e1) {
            // empty catch block
        }
    }

    protected boolean isDeclared(Object cla, Method readMethod) {
        try {
            return cla.getClass().getDeclaredMethod(readMethod.getName(), readMethod.getParameterTypes()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

