/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.xml.sax.SAXException;

public class GrailsRepoResolver
extends URLResolver {
    protected URL repositoryRoot;

    public GrailsRepoResolver(String name, URL repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
        this.setName(name);
    }

    public URL getRepositoryRoot() {
        return this.repositoryRoot;
    }

    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId mrid, String pattern, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        pattern = this.transformGrailsRepositoryPattern(mrid, pattern);
        return super.findResourceUsingPattern(mrid, pattern, artifact, rmdparser, date);
    }

    public String transformGrailsRepositoryPattern(ModuleRevisionId mrid, String pattern) {
        String revision = mrid.getRevision();
        String versionTag = revision.equals("latest.integration") || revision.equals("latest") ? "LATEST_RELEASE" : "RELEASE_" + revision.replace('.', '_');
        return pattern.replace("RELEASE_*", versionTag);
    }

    public GPathResult getPluginList(File localFile) {
        try {
            Repository repo = this.getRepository();
            List list = repo.list(this.repositoryRoot.toString());
            for (Object entry : list) {
                String url = entry.toString();
                if (!url.contains(".plugin-meta")) continue;
                List metaList = repo.list(url);
                for (Object current : metaList) {
                    url = current.toString();
                    if (!url.contains("plugins-list.xml")) continue;
                    Resource remoteFile = repo.getResource(url);
                    if (localFile.lastModified() < remoteFile.getLastModified()) {
                        repo.get(url, localFile);
                    }
                    return new XmlSlurper().parse(localFile);
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        return null;
    }
}

