/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.codehaus.groovy.grails.cli.support.GrailsRootLoader;
import org.codehaus.groovy.tools.LoaderConfiguration;

public class GrailsStarter {
    static void printUsage() {
        System.out.println("possible programs are 'groovyc','groovy','console', and 'groovysh'");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rootLoader(String[] args) {
        String conf = System.getProperty("groovy.starter.conf", null);
        LoaderConfiguration lc = new LoaderConfiguration();
        boolean hadMain = false;
        boolean hadConf = false;
        boolean hadCP = false;
        int argsOffset = 0;
        while (!(args.length - argsOffset <= 0 || hadMain && hadConf && hadCP)) {
            if (args[argsOffset].equals("--classpath")) {
                if (hadCP) break;
                if (args.length == argsOffset + 1) {
                    GrailsStarter.exit("classpath parameter needs argument");
                }
                lc.addClassPath(args[argsOffset + 1]);
                argsOffset += 2;
                continue;
            }
            if (args[argsOffset].equals("--main")) {
                if (hadMain) break;
                if (args.length == argsOffset + 1) {
                    GrailsStarter.exit("main parameter needs argument");
                }
                lc.setMainClass(args[argsOffset + 1]);
                argsOffset += 2;
                continue;
            }
            if (!args[argsOffset].equals("--conf") || hadConf) break;
            if (args.length == argsOffset + 1) {
                GrailsStarter.exit("conf parameter needs argument");
            }
            conf = args[argsOffset + 1];
            argsOffset += 2;
        }
        if (lc.getMainClass() == null && conf == null) {
            GrailsStarter.exit("no configuration file or main class specified");
        }
        String[] newArgs = new String[args.length - argsOffset];
        for (int i = 0; i < newArgs.length; ++i) {
            newArgs[i] = args[i + argsOffset];
        }
        String basedir = System.getProperty("base.dir");
        if (basedir != null) {
            try {
                System.setProperty("base.name", new File(basedir).getCanonicalFile().getName());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (conf != null) {
            try {
                lc.configure((InputStream)new FileInputStream(conf));
            }
            catch (Exception e) {
                System.err.println("exception while configuring main class loader:");
                GrailsStarter.exit(e);
            }
        }
        GrailsRootLoader loader = new GrailsRootLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)loader));
        URL[] urls = lc.getClassPathUrls();
        for (int i = 0; i < urls.length; ++i) {
            loader.addURL(urls[i]);
        }
        String javaVersion = System.getProperty("java.version");
        String grailsHome = System.getProperty("grails.home");
        if (javaVersion != null && grailsHome != null) {
            javaVersion = javaVersion.substring(0, 3);
            File vmConfig = new File(grailsHome + "/conf/groovy-starter-java-" + javaVersion + ".conf");
            if (vmConfig.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(vmConfig);
                    LoaderConfiguration vmLoaderConfig = new LoaderConfiguration();
                    vmLoaderConfig.setRequireMain(false);
                    vmLoaderConfig.configure((InputStream)in);
                    URL[] vmSpecificClassPath = vmLoaderConfig.getClassPathUrls();
                    for (int i = 0; i < vmSpecificClassPath.length; ++i) {
                        loader.addURL(vmSpecificClassPath[i]);
                    }
                }
                catch (IOException e) {
                    System.out.println("WARNING: I/O error reading VM specific classpath [" + vmConfig + "]: " + e.getMessage());
                }
                finally {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
        Method m = null;
        try {
            Class c = loader.loadClass(lc.getMainClass());
            m = c.getMethod("main", String[].class);
        }
        catch (ClassNotFoundException e1) {
            GrailsStarter.exit(e1);
        }
        catch (SecurityException e2) {
            GrailsStarter.exit(e2);
        }
        catch (NoSuchMethodException e2) {
            GrailsStarter.exit(e2);
        }
        try {
            m.invoke(null, new Object[]{newArgs});
        }
        catch (IllegalArgumentException e3) {
            GrailsStarter.exit(e3);
        }
        catch (IllegalAccessException e3) {
            GrailsStarter.exit(e3);
        }
        catch (InvocationTargetException e3) {
            GrailsStarter.exit(e3);
        }
    }

    private static void exit(Exception e) {
        e.printStackTrace();
        System.exit(1);
    }

    private static void exit(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            GrailsStarter.rootLoader(args);
        }
        catch (Throwable t) {
            System.out.println("Error starting Grails: " + t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

