/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo.tasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.spi.ToolProvider;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;

public abstract class ModuleDescriptorRecommendation
extends DefaultTask {
    private static final Pattern REQUIRES_PATTERN = Pattern.compile("^ {4}requires (transitive )?(.*);$");
    private static final Pattern EXPORTS_PATTERN = Pattern.compile("^ {4}exports (.*);$");
    private static final Pattern PROVIDES_PATTERN = Pattern.compile("^ {4}provides (.*) with$");
    private static final Pattern AUTOMATIC_MODULE_NAME_PATTERN = Pattern.compile("(.*?)(@.*)? automatic");
    private static final Pattern MODULE_INFO_CLASS_MODULE_NAME_PATTERN = Pattern.compile("(.*?)(@.*)? jar:(.*)");

    @InputFiles
    public abstract ListProperty<File> getRuntimeArtifacts();

    @Input
    public abstract ListProperty<ResolvedComponentResult> getRuntimeResolvedComponentResults();

    @InputFiles
    public abstract ListProperty<File> getCompileArtifacts();

    @Input
    public abstract ListProperty<ResolvedComponentResult> getCompileResolvedComponentResults();

    @Input
    public abstract Property<Integer> getRelease();

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @TaskAction
    public void execute() throws IOException {
        Java8SafeToolProvider jdepsTool = Java8SafeToolProvider.findFirst("jdeps");
        Java8SafeToolProvider jarTool = Java8SafeToolProvider.findFirst("jar");
        HashMap<ModuleIdentifier, Artifact> artifacts = new HashMap<ModuleIdentifier, Artifact>();
        ModuleDescriptorRecommendation.extractArtifactsAndTheirDependencies(artifacts, (List)this.getRuntimeArtifacts().get(), (List)this.getRuntimeResolvedComponentResults().get(), artifact -> artifact.runtimeDependencies);
        ModuleDescriptorRecommendation.extractArtifactsAndTheirDependencies(artifacts, (List)this.getCompileArtifacts().get(), (List)this.getCompileResolvedComponentResults().get(), artifact -> artifact.compileDependencies);
        Path temporaryFolder = Files.createTempDirectory("jdeps-task", new FileAttribute[0]);
        for (Map.Entry entry2 : artifacts.entrySet()) {
            Artifact artifact2 = (Artifact)entry2.getValue();
            this.storeJarToolParsedMetadata(jarTool, artifact2);
            if (!artifact2.automatic) continue;
            this.storeJdepsToolParsedMetadata(jdepsTool, temporaryFolder, artifact2, artifacts.values());
        }
        ArrayList<Artifact> modulesToRecommend = new ArrayList<Artifact>();
        for (Map.Entry entry3 : artifacts.entrySet()) {
            Artifact artifact3 = (Artifact)entry3.getValue();
            if (!artifact3.automatic) continue;
            for (ModuleIdentifier dependency : artifact3.allDependencies()) {
                Artifact dependencyArtifact = (Artifact)artifacts.get(dependency);
                if (artifact3.containsAnyRequires(dependencyArtifact.moduleName)) continue;
                boolean hasCompileDependency = artifact3.compileDependencies.contains(dependencyArtifact.coordinates);
                boolean hasRuntimeDependency = artifact3.runtimeDependencies.contains(dependencyArtifact.coordinates);
                if (hasCompileDependency && hasRuntimeDependency) {
                    artifact3.requiresTransitive.add(dependencyArtifact.moduleName);
                    continue;
                }
                if (hasRuntimeDependency) {
                    artifact3.requires.add(dependencyArtifact.moduleName);
                    continue;
                }
                if (!hasCompileDependency) continue;
                artifact3.requiresStatic.add(dependencyArtifact.moduleName);
            }
            modulesToRecommend.add(artifact3);
        }
        modulesToRecommend.sort(Comparator.comparing(entry -> entry.coordinates.getGroup()).thenComparing(entry -> entry.coordinates.getName()));
        for (Artifact artifact2 : modulesToRecommend) {
            System.out.println(artifact2.dsl());
        }
        if (modulesToRecommend.isEmpty()) {
            System.out.println("All good. Looks like all the dependencies have the proper module-info.class defined");
        }
        this.getFileSystemOperations().delete(spec -> spec.delete(new Object[]{temporaryFolder}));
    }

    private static void extractArtifactsAndTheirDependencies(Map<ModuleIdentifier, Artifact> jarsToAnalyze, List<File> artifacts, List<ResolvedComponentResult> resolvedComponentResults, Function<Artifact, Set<ModuleIdentifier>> depsSink) {
        for (ResolvedComponentResult artifact : resolvedComponentResults) {
            ComponentIdentifier identifier = artifact.getId();
            if (!(identifier instanceof ModuleComponentIdentifier)) continue;
            ModuleIdentifier moduleIdentifier = ((ModuleComponentIdentifier)identifier).getModuleIdentifier();
            int index = resolvedComponentResults.indexOf(artifact);
            jarsToAnalyze.computeIfAbsent(moduleIdentifier, ignore -> new Artifact(moduleIdentifier, (File)artifacts.get(index)));
        }
        for (ResolvedComponentResult resolvedComponent : resolvedComponentResults) {
            Artifact artifact;
            ModuleVersionIdentifier moduleVersion = resolvedComponent.getModuleVersion();
            if (moduleVersion == null || (artifact = jarsToAnalyze.get(moduleVersion.getModule())) == null) continue;
            for (DependencyResult dependency : resolvedComponent.getDependencies()) {
                ModuleVersionIdentifier dependantModuleVersion;
                if (!(dependency instanceof ResolvedDependencyResult) || (dependantModuleVersion = ((ResolvedDependencyResult)dependency).getSelected().getModuleVersion()) == null) continue;
                depsSink.apply(artifact).add(dependantModuleVersion.getModule());
            }
        }
    }

    private void storeJdepsToolParsedMetadata(Java8SafeToolProvider jdeps, Path outputPath, Artifact targetArtifact, Collection<Artifact> jars) throws IOException {
        String[] parts;
        ArrayList<String> modulePath = new ArrayList<String>();
        for (Artifact artifact : jars) {
            if (artifact.equals(targetArtifact)) continue;
            modulePath.add(artifact.jar.getAbsolutePath());
        }
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        ArrayList<String> args = new ArrayList<String>();
        if (!modulePath.isEmpty()) {
            args.addAll(List.of("--module-path", String.join((CharSequence)File.pathSeparator, modulePath)));
        }
        args.addAll(List.of("--generate-module-info", outputPath.toString()));
        args.addAll(List.of("--multi-release", String.valueOf(this.getRelease().get())));
        args.add("--ignore-missing-deps");
        args.add(targetArtifact.jar.getAbsolutePath());
        int retVal = jdeps.run(new PrintWriter((Writer)out, true), new PrintWriter((Writer)err, true), (String[])args.toArray(String[]::new));
        if (retVal != 0) {
            throw new RuntimeException(String.format("jdeps returned error %d\n%s\n%s", retVal, out, err));
        }
        String[] result = out.toString().split("\\R");
        String writingToMessage = result.length == 2 ? result[1] : result[0];
        String path = writingToMessage.replace("writing to ", "");
        String moduleInfoJava = Files.readString(Path.of(path, new String[0]));
        for (String part : parts = moduleInfoJava.split("\\R")) {
            Matcher requiresMatcher = REQUIRES_PATTERN.matcher(part);
            if (requiresMatcher.matches()) {
                if (requiresMatcher.group(1) == null) {
                    targetArtifact.requires.add(requiresMatcher.group(2));
                    continue;
                }
                targetArtifact.requiresTransitive.add(requiresMatcher.group(2));
                continue;
            }
            Matcher exportsMatcher = EXPORTS_PATTERN.matcher(part);
            if (exportsMatcher.matches()) {
                targetArtifact.exports.add(exportsMatcher.group(1));
                continue;
            }
            Matcher providesMatcher = PROVIDES_PATTERN.matcher(part);
            if (!providesMatcher.matches()) continue;
            targetArtifact.provides.add(providesMatcher.group(1));
        }
    }

    private void storeJarToolParsedMetadata(Java8SafeToolProvider jar, Artifact artifact) {
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        int retVal = jar.run(new PrintWriter((Writer)out, true), new PrintWriter((Writer)err, true), "--describe-module", "--file", artifact.jar.getAbsolutePath(), "--release", String.valueOf(this.getRelease().get()));
        if (retVal != 0) {
            throw new RuntimeException(String.format("jar returned error %d\n%s\n%s", retVal, out, err));
        }
        String[] result = out.toString().split("\\R");
        if (result[0].equals("No module descriptor found. Derived automatic module.")) {
            Matcher matcher = AUTOMATIC_MODULE_NAME_PATTERN.matcher(result[2]);
            if (!matcher.matches()) {
                throw new RuntimeException("Cannot extract module name from: " + out);
            }
            artifact.moduleName = matcher.group(1);
            artifact.automatic = true;
        } else {
            Matcher matcher = MODULE_INFO_CLASS_MODULE_NAME_PATTERN.matcher(result[0].startsWith("releases: ") ? result[2] : result[0]);
            if (!matcher.matches()) {
                throw new RuntimeException("Cannot extract module name from: " + out);
            }
            artifact.moduleName = matcher.group(1);
            artifact.automatic = false;
        }
    }

    static interface Java8SafeToolProvider {
        public int run(PrintWriter var1, PrintWriter var2, String ... var3);

        public static Java8SafeToolProvider findFirst(String name) {
            try {
                ToolProvider tool = ToolProvider.findFirst(name).orElseThrow(() -> new RuntimeException("The JDK does not bundle " + name));
                return tool::run;
            }
            catch (NoClassDefFoundError e) {
                throw new RuntimeException("This functionality requires Gradle to be powered by JDK 11+", e);
            }
        }
    }

    private static final class Artifact {
        final ModuleIdentifier coordinates;
        final Set<ModuleIdentifier> runtimeDependencies = new HashSet<ModuleIdentifier>();
        final Set<ModuleIdentifier> compileDependencies = new HashSet<ModuleIdentifier>();
        final File jar;
        final SortedSet<String> requires = new TreeSet<String>();
        final SortedSet<String> requiresTransitive = new TreeSet<String>();
        final SortedSet<String> requiresStatic = new TreeSet<String>();
        final SortedSet<String> exports = new TreeSet<String>();
        final SortedSet<String> provides = new TreeSet<String>();
        String moduleName;
        boolean automatic;

        Artifact(ModuleIdentifier coordinates, File jar) {
            this.coordinates = coordinates;
            this.jar = jar;
        }

        Set<ModuleIdentifier> allDependencies() {
            HashSet<ModuleIdentifier> out = new HashSet<ModuleIdentifier>();
            out.addAll(this.compileDependencies);
            out.addAll(this.runtimeDependencies);
            return out;
        }

        boolean containsAnyRequires(String moduleName) {
            return this.requires.contains(moduleName) || this.requiresTransitive.contains(moduleName) || this.requiresStatic.contains(moduleName);
        }

        String dsl() {
            ArrayList<String> out = new ArrayList<String>();
            String group = this.coordinates.getGroup();
            String name = this.coordinates.getName();
            String moduleName = this.moduleName;
            out.add("module('" + group + ":" + name + "', '" + moduleName + "') {");
            out.add("    closeModule()");
            for (String item : this.requiresTransitive) {
                out.add("    requiresTransitive('" + item + "')");
            }
            for (String item : this.requiresStatic) {
                out.add("    requiresStatic('" + item + "')");
            }
            for (String item : this.requires) {
                out.add("    requires('" + item + "')");
            }
            for (String item : this.exports) {
                out.add("    exports('" + item + "')");
            }
            for (String item : this.provides) {
                out.add("    // ignoreServiceProvider('" + item + "')");
            }
            out.add("}");
            return String.join((CharSequence)"\n", out).replace('\'', '\"');
        }
    }
}

