/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradlex.javamodule.moduleinfo.ExtraJavaModuleInfoPlugin;

public class PublishedMetadata
implements Serializable {
    private static final Attribute<String> CATEGORY_ATTRIBUTE_UNTYPED = Attribute.of((String)Category.CATEGORY_ATTRIBUTE.getName(), String.class);
    private final String gav;
    private final List<String> requires = new ArrayList<String>();
    private final List<String> requiresTransitive = new ArrayList<String>();
    private final List<String> requiresStaticTransitive = new ArrayList<String>();

    PublishedMetadata(String gav, Configuration origin, Project project) {
        this.gav = gav;
        List<String> compileDependencies = this.componentVariant(origin, project, "java-api");
        List<String> runtimeDependencies = this.componentVariant(origin, project, "java-runtime");
        Stream.concat(compileDependencies.stream(), runtimeDependencies.stream()).distinct().forEach(ga -> {
            if (compileDependencies.contains(ga) && runtimeDependencies.contains(ga)) {
                this.requiresTransitive.add((String)ga);
            } else if (runtimeDependencies.contains(ga)) {
                this.requires.add((String)ga);
            } else if (compileDependencies.contains(ga)) {
                this.requiresStaticTransitive.add((String)ga);
            }
        });
    }

    private List<String> componentVariant(Configuration origin, Project project, String usage) {
        Configuration singleComponentVariantResolver = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)this.gav)});
        singleComponentVariantResolver.setCanBeConsumed(false);
        singleComponentVariantResolver.shouldResolveConsistentlyWith(origin);
        origin.getAttributes().keySet().forEach(a -> {
            Attribute untypedAttributeKey = a;
            singleComponentVariantResolver.getAttributes().attribute(untypedAttributeKey, Objects.requireNonNull(origin.getAttributes().getAttribute(a)));
        });
        singleComponentVariantResolver.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, usage)));
        return this.firstAndOnlyComponent(singleComponentVariantResolver).getDependencies().stream().filter(PublishedMetadata::filterComponentDependencies).map(PublishedMetadata::ga).collect(Collectors.toList());
    }

    private ResolvedComponentResult firstAndOnlyComponent(Configuration singleComponentVariantResolver) {
        ResolvedDependencyResult onlyResult = (ResolvedDependencyResult)singleComponentVariantResolver.getIncoming().getResolutionResult().getRoot().getDependencies().iterator().next();
        return onlyResult.getSelected();
    }

    private static boolean filterComponentDependencies(DependencyResult d) {
        if (d instanceof ResolvedDependencyResult) {
            Category category = (Category)((ResolvedDependencyResult)d).getResolvedVariant().getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
            String categoryUntyped = (String)((ResolvedDependencyResult)d).getResolvedVariant().getAttributes().getAttribute(CATEGORY_ATTRIBUTE_UNTYPED);
            return "library".equals(categoryUntyped) || category != null && "library".equals(category.getName());
        }
        return false;
    }

    private static String ga(DependencyResult d) {
        if (d instanceof ResolvedDependencyResult) {
            return ExtraJavaModuleInfoPlugin.ga(((ResolvedDependencyResult)d).getSelected().getId());
        }
        return d.getRequested().getDisplayName();
    }

    public String getGav() {
        return this.gav;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public List<String> getRequiresTransitive() {
        return this.requiresTransitive;
    }

    public List<String> getRequiresStaticTransitive() {
        return this.requiresStaticTransitive;
    }
}

