/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.provider.Provider;
import org.gradlex.javamodule.moduleinfo.IdValidator;
import org.gradlex.javamodule.moduleinfo.ModuleNameUtil;

public abstract class ModuleSpec
implements Serializable {
    private final String identifier;
    private final String moduleName;
    private final List<String> mergedJars = new ArrayList<String>();
    boolean overrideModuleName;

    protected ModuleSpec(String identifier, String moduleName) {
        IdValidator.validateIdentifier(identifier);
        ModuleNameUtil.validateModuleName(moduleName);
        this.identifier = identifier;
        this.moduleName = moduleName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void mergeJar(String identifier) {
        this.mergedJars.add(identifier);
    }

    public void mergeJar(Provider<MinimalExternalModuleDependency> alias) {
        this.mergeJar(((MinimalExternalModuleDependency)alias.get()).getModule().toString());
    }

    public List<String> getMergedJars() {
        return this.mergedJars;
    }

    public void overrideModuleName() {
        this.overrideModuleName = true;
    }
}

