/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

final class FilePathToModuleCoordinates {
    FilePathToModuleCoordinates() {
    }

    @Nullable
    static String versionFromFilePath(Path path) {
        if (FilePathToModuleCoordinates.isInGradleCache(path)) {
            return FilePathToModuleCoordinates.getVersionFromGradleCachePath(path);
        }
        if (FilePathToModuleCoordinates.isInM2Cache(path)) {
            return FilePathToModuleCoordinates.getVersionFromM2CachePath(path);
        }
        return null;
    }

    static boolean gaCoordinatesFromFilePathMatch(Path path, String ga) {
        String name = FilePathToModuleCoordinates.nameCoordinateFromFilePath(path);
        String group = FilePathToModuleCoordinates.groupCoordinateFromFilePath(path);
        if (name == null || group == null) {
            return false;
        }
        return FilePathToModuleCoordinates.isInGradleCache(path) && ga.equals(group + ":" + name) || FilePathToModuleCoordinates.isInM2Cache(path) && (group + ":" + name).endsWith("." + ga);
    }

    @Nullable
    private static String groupCoordinateFromFilePath(Path path) {
        if (FilePathToModuleCoordinates.isInGradleCache(path)) {
            return path.getName(path.getNameCount() - 5).toString();
        }
        if (FilePathToModuleCoordinates.isInM2Cache(path)) {
            return StreamSupport.stream(path.subpath(0, path.getNameCount() - 3).spliterator(), false).map(Path::toString).collect(Collectors.joining("."));
        }
        return null;
    }

    static boolean isInGradleCache(Path path) {
        String name = FilePathToModuleCoordinates.nameCoordinateFromFilePath(path);
        if (name == null) {
            return false;
        }
        String version = FilePathToModuleCoordinates.getVersionFromGradleCachePath(path);
        return path.getFileName().toString().startsWith(name + "-" + version);
    }

    static boolean isInM2Cache(Path path) {
        String name = FilePathToModuleCoordinates.nameCoordinateFromFilePath(path);
        if (name == null) {
            return false;
        }
        String version = FilePathToModuleCoordinates.getVersionFromM2CachePath(path);
        return path.getFileName().toString().startsWith(name + "-" + version);
    }

    @Nullable
    private static String nameCoordinateFromFilePath(Path path) {
        if (path.getNameCount() < 5) {
            return null;
        }
        String nameFromGradleCachePath = path.getName(path.getNameCount() - 4).toString();
        String versionFromGradleCachePath = FilePathToModuleCoordinates.getVersionFromGradleCachePath(path);
        if (path.getFileName().toString().startsWith(nameFromGradleCachePath + "-" + versionFromGradleCachePath)) {
            return nameFromGradleCachePath;
        }
        String nameFromM2CachePath = path.getName(path.getNameCount() - 3).toString();
        String versionFromM2CachePath = FilePathToModuleCoordinates.getVersionFromM2CachePath(path);
        if (path.getFileName().toString().startsWith(nameFromM2CachePath + "-" + versionFromM2CachePath)) {
            return nameFromM2CachePath;
        }
        return null;
    }

    private static String getVersionFromGradleCachePath(Path path) {
        return path.getName(path.getNameCount() - 3).toString();
    }

    private static String getVersionFromM2CachePath(Path path) {
        return path.getName(path.getNameCount() - 2).toString();
    }
}

