/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ModuleNameUtil {
    private static final Pattern DASH_VERSION = Pattern.compile("-(\\d+(\\.|$))");
    private static final Pattern NON_ALPHANUM = Pattern.compile("[^A-Za-z0-9]");
    private static final Pattern REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
    private static final Pattern LEADING_DOTS = Pattern.compile("^\\.");
    private static final Pattern TRAILING_DOTS = Pattern.compile("\\.$");
    private static final List<String> RESERVED = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "_");

    ModuleNameUtil() {
    }

    static String automaticModulNameFromFileName(File jarFile) {
        String name;
        Matcher matcher;
        String fn = jarFile.getName();
        int i = fn.lastIndexOf(File.separator);
        if (i != -1) {
            fn = fn.substring(i + 1);
        }
        if ((matcher = DASH_VERSION.matcher(name = fn.substring(0, fn.length() - 4))).find()) {
            name = name.substring(0, matcher.start());
        }
        return ModuleNameUtil.validateModuleName(ModuleNameUtil.cleanModuleName(name));
    }

    static String validateModuleName(String name) {
        int next;
        int off = 0;
        while ((next = name.indexOf(46, off)) != -1) {
            String id = name.substring(off, next);
            if (!ModuleNameUtil.isJavaIdentifier(id)) {
                throw new IllegalArgumentException(name + ": Invalid module name: '" + id + "' is not a Java identifier");
            }
            off = next + 1;
        }
        String last = name.substring(off);
        if (!ModuleNameUtil.isJavaIdentifier(last)) {
            throw new IllegalArgumentException(name + ": Invalid module name: '" + last + "' is not a Java identifier");
        }
        return name;
    }

    private static String cleanModuleName(String mn) {
        int len;
        mn = NON_ALPHANUM.matcher(mn).replaceAll(".");
        if (!(mn = REPEATING_DOTS.matcher(mn).replaceAll(".")).isEmpty() && mn.charAt(0) == '.') {
            mn = LEADING_DOTS.matcher(mn).replaceAll("");
        }
        if ((len = mn.length()) > 0 && mn.charAt(len - 1) == '.') {
            mn = TRAILING_DOTS.matcher(mn).replaceAll("");
        }
        return mn;
    }

    private static boolean isJavaIdentifier(String str) {
        int cp;
        if (str.isEmpty() || RESERVED.contains(str)) {
            return false;
        }
        int first = Character.codePointAt(str, 0);
        if (!Character.isJavaIdentifierStart(first)) {
            return false;
        }
        for (int i = Character.charCount(first); i < str.length(); i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }
}

