/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import java.io.CharArrayReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;
import org.gradlex.javamodule.moduleinfo.ExtraJavaModuleInfoPluginExtension;
import org.gradlex.javamodule.moduleinfo.ExtraJavaModuleInfoTransform;
import org.gradlex.javamodule.moduleinfo.IdValidator;
import org.gradlex.javamodule.moduleinfo.ModuleInfo;
import org.gradlex.javamodule.moduleinfo.ModuleSpec;
import org.gradlex.javamodule.moduleinfo.PublishedMetadata;
import org.gradlex.javamodule.moduleinfo.tasks.ModuleDescriptorRecommendation;

@NonNullApi
public abstract class ExtraJavaModuleInfoPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.8")) < 0) {
            throw new RuntimeException("This plugin requires Gradle 6.8+");
        }
        ExtraJavaModuleInfoPluginExtension extension = (ExtraJavaModuleInfoPluginExtension)project.getExtensions().create("extraJavaModuleInfo", ExtraJavaModuleInfoPluginExtension.class, new Object[0]);
        extension.getFailOnMissingModuleInfo().convention((Object)true);
        extension.getFailOnAutomaticModules().convention((Object)false);
        extension.getDeriveAutomaticModuleNamesFromFileNames().convention((Object)false);
        project.getPlugins().withType(JavaPlugin.class).configureEach(javaPlugin -> {
            this.configureTransform(project, extension);
            this.configureModuleDescriptorTasks(project);
        });
    }

    private void configureModuleDescriptorTasks(Project project) {
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> {
            String name = sourceSet.getTaskName("", "moduleDescriptorRecommendations");
            project.getTasks().register(name, ModuleDescriptorRecommendation.class, task -> {
                Transformer artifactsTransformer = configuration -> configuration.getIncoming().getArtifacts().getArtifacts().stream().sorted(Comparator.comparing(artifact -> artifact.getId().getComponentIdentifier().toString())).map(ResolvedArtifactResult::getFile).collect(Collectors.toList());
                Transformer componentsTransformer = configuration -> {
                    Set artifacts = configuration.getIncoming().getArtifacts().getArtifacts().stream().map(artifact -> artifact.getId().getComponentIdentifier()).collect(Collectors.toSet());
                    return configuration.getIncoming().getResolutionResult().getAllComponents().stream().filter(component -> artifacts.contains(component.getId())).sorted(Comparator.comparing(artifact -> artifact.getId().toString())).collect(Collectors.toList());
                };
                NamedDomainObjectProvider compileClasspath = project.getConfigurations().named(sourceSet.getCompileClasspathConfigurationName());
                task.getCompileArtifacts().set(compileClasspath.map(artifactsTransformer));
                task.getCompileResolvedComponentResults().set(compileClasspath.map(componentsTransformer));
                NamedDomainObjectProvider runtimeClasspath = project.getConfigurations().named(sourceSet.getRuntimeClasspathConfigurationName());
                task.getRuntimeArtifacts().set(runtimeClasspath.map(artifactsTransformer));
                task.getRuntimeResolvedComponentResults().set(runtimeClasspath.map(componentsTransformer));
                task.getRelease().convention((Object)21);
                task.setGroup("help");
                task.setDescription("Generates module descriptors for 'org.gradlex.extra-java-module-info' plugin based on the dependency and class file analysis of automatic modules and non-modular dependencies");
            });
        });
    }

    private void configureTransform(Project project, ExtraJavaModuleInfoPluginExtension extension) {
        Configuration javaModulesMergeJars = (Configuration)project.getConfigurations().create("javaModulesMergeJars", c -> {
            c.setVisible(false);
            c.setCanBeConsumed(false);
            c.setCanBeResolved(true);
            c.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime")));
            c.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "library")));
            c.withDependencies(d -> ((Map)extension.getModuleSpecs().get()).values().stream().flatMap(m -> m.getMergedJars().stream()).filter(s -> s.contains(":")).forEach(s -> d.add((Object)project.getDependencies().create(s))));
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.8")) >= 0) {
                c.shouldResolveConsistentlyWith(project.getConfigurations().getByName("runtimeClasspath"));
            }
        });
        project.getConfigurations().all(otherConfiguration -> {
            if ("internal".equals(otherConfiguration.getName())) {
                javaModulesMergeJars.extendsFrom(new Configuration[]{otherConfiguration});
            }
        });
        Attribute artifactType = Attribute.of((String)"artifactType", String.class);
        Attribute javaModule = Attribute.of((String)"javaModule", Boolean.class);
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> {
            Configuration runtimeClasspath = project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName());
            Configuration compileClasspath = project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName());
            Configuration annotationProcessor = project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName());
            runtimeClasspath.getAttributes().attribute(javaModule, (Object)true);
            compileClasspath.getAttributes().attribute(javaModule, (Object)true);
            annotationProcessor.getAttributes().attribute(javaModule, (Object)true);
        });
        this.registerTransform("jar", project, extension, javaModulesMergeJars, (Attribute<String>)artifactType, (Attribute<Boolean>)javaModule);
        this.registerTransform("zip", project, extension, javaModulesMergeJars, (Attribute<String>)artifactType, (Attribute<Boolean>)javaModule);
    }

    private void registerTransform(String fileExtension, Project project, ExtraJavaModuleInfoPluginExtension extension, Configuration javaModulesMergeJars, Attribute<String> artifactType, Attribute<Boolean> javaModule) {
        DependencyHandler dependencies = project.getDependencies();
        ConfigurationContainer configurations = project.getConfigurations();
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        ((ArtifactTypeDefinition)dependencies.getArtifactTypes().maybeCreate(fileExtension)).getAttributes().attribute(javaModule, (Object)false);
        dependencies.registerTransform(ExtraJavaModuleInfoTransform.class, t -> {
            t.parameters(p -> {
                p.getModuleSpecs().set(extension.getModuleSpecs());
                p.getFailOnMissingModuleInfo().set(extension.getFailOnMissingModuleInfo());
                p.getFailOnAutomaticModules().set(extension.getFailOnAutomaticModules());
                p.getDeriveAutomaticModuleNamesFromFileNames().set(extension.getDeriveAutomaticModuleNamesFromFileNames());
                Provider artifacts = project.provider(() -> javaModulesMergeJars.getIncoming().artifactView(v -> v.lenient(true)).getArtifacts().getArtifacts());
                p.getMergeJarIds().set(artifacts.map((Transformer)new IdExtractor()));
                p.getMergeJars().set(artifacts.map((Transformer)new FileExtractor(project.getLayout())));
                Provider<Set<String>> componentsOfInterest = ExtraJavaModuleInfoPlugin.componentsOfInterest(extension);
                p.getRequiresFromMetadata().set(componentsOfInterest.map(gaSet -> gaSet.stream().collect(Collectors.toMap(ga -> ga, ga -> new PublishedMetadata((String)ga, project, extension)))));
                p.getAdditionalKnownModules().set(this.extractFromModuleDependenciesPlugin(project));
            });
            t.getFrom().attribute(artifactType, (Object)fileExtension).attribute(javaModule, (Object)false);
            t.getTo().attribute(artifactType, (Object)fileExtension).attribute(javaModule, (Object)true);
        });
    }

    private Provider<Map<String, String>> extractFromModuleDependenciesPlugin(Project project) {
        return project.provider(() -> {
            Object javaModuleDependencies = project.getExtensions().findByName("javaModuleDependencies");
            if (javaModuleDependencies == null) {
                return Collections.emptyMap();
            }
            try {
                Method getModulesProperties = javaModuleDependencies.getClass().getMethod("getModulesProperties", new Class[0]);
                RegularFileProperty file = (RegularFileProperty)getModulesProperties.invoke(javaModuleDependencies, new Object[0]);
                return (Map)project.getProviders().fileContents((Provider)file).getAsText().map(c -> {
                    Properties p = new Properties();
                    try {
                        p.load(new CharArrayReader(c.toCharArray()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    Properties result = p;
                    return result;
                }).getOrElse(Collections.emptyMap());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Provider<Set<String>> componentsOfInterest(ExtraJavaModuleInfoPluginExtension extension) {
        return extension.getModuleSpecs().map(specs -> specs.values().stream().filter(ExtraJavaModuleInfoPlugin::needsDependencies).map(ModuleSpec::getIdentifier).collect(Collectors.toSet()));
    }

    private static boolean needsDependencies(ModuleSpec moduleSpec) {
        return moduleSpec instanceof ModuleInfo && ((ModuleInfo)moduleSpec).requireAllDefinedDependencies && IdValidator.isCoordinates(moduleSpec.getIdentifier());
    }

    static String ga(ComponentIdentifier id) {
        if (id instanceof ModuleComponentIdentifier) {
            return ((ModuleComponentIdentifier)id).getGroup() + ":" + ((ModuleComponentIdentifier)id).getModule();
        }
        return id.getDisplayName();
    }

    private static class IdExtractor
    implements Transformer<List<String>, Collection<ResolvedArtifactResult>> {
        private IdExtractor() {
        }

        public List<String> transform(Collection<ResolvedArtifactResult> artifacts) {
            return artifacts.stream().map(a -> {
                ComponentIdentifier componentIdentifier = a.getId().getComponentIdentifier();
                if (componentIdentifier instanceof ModuleComponentIdentifier) {
                    return ((ModuleComponentIdentifier)componentIdentifier).getModuleIdentifier().toString();
                }
                return componentIdentifier.getDisplayName();
            }).collect(Collectors.toList());
        }
    }

    private static class FileExtractor
    implements Transformer<List<RegularFile>, Collection<ResolvedArtifactResult>> {
        private final ProjectLayout projectLayout;

        public FileExtractor(ProjectLayout projectLayout) {
            this.projectLayout = projectLayout;
        }

        public List<RegularFile> transform(Collection<ResolvedArtifactResult> artifacts) {
            Directory projectDirectory = this.projectLayout.getProjectDirectory();
            return artifacts.stream().map(a -> projectDirectory.file(a.getFile().getAbsolutePath())).collect(Collectors.toList());
        }
    }
}

