/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.toolchains.foojay;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.platform.Architecture;
import org.gradle.platform.OperatingSystem;
import org.gradle.toolchains.foojay.Distribution;
import org.gradle.toolchains.foojay.DistributionsKt;
import org.gradle.toolchains.foojay.FoojayApi;
import org.gradle.toolchains.foojay.Links;
import org.gradle.toolchains.foojay.Package;
import org.gradle.toolchains.foojay.PackagesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J/\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J3\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\tH\u0002J8\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010'\u001a\u00020\u000b2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006."}, d2={"Lorg/gradle/toolchains/foojay/FoojayApi;", "", "()V", "distributions", "", "Lorg/gradle/toolchains/foojay/Distribution;", "getDistributions", "()Ljava/util/List;", "createConnection", "Ljava/net/HttpURLConnection;", "endpoint", "", "parameters", "", "fetchDistributionsIfMissing", "", "match", "Lorg/gradle/toolchains/foojay/Package;", "distributionName", "version", "Lorg/gradle/jvm/toolchain/JavaLanguageVersion;", "operatingSystem", "Lorg/gradle/platform/OperatingSystem;", "architecture", "Lorg/gradle/platform/Architecture;", "match$foojay_resolver", "", "vendor", "Lorg/gradle/jvm/toolchain/JvmVendorSpec;", "implementation", "Lorg/gradle/jvm/toolchain/JvmImplementation;", "nativeImageCapable", "", "readContent", "stream", "Ljava/io/InputStream;", "readResponse", "con", "toPackage", "toParameterString", "params", "toUri", "Ljava/net/URI;", "links", "Lorg/gradle/toolchains/foojay/Links;", "Companion", "foojay-resolver"})
@SourceDebugExtension(value={"SMAP\nFoojayApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FoojayApi.kt\norg/gradle/toolchains/foojay/FoojayApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class FoojayApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Distribution> distributions = new ArrayList();
    private static final int CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(10L);
    private static final int READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);
    @NotNull
    public static final String SCHEMA = "https";
    @NotNull
    private static final String ENDPOINT_ROOT = "api.foojay.io/disco/v3.0";
    @NotNull
    public static final String DISTRIBUTIONS_ENDPOINT = "api.foojay.io/disco/v3.0/distributions";
    @NotNull
    public static final String PACKAGES_ENDPOINT = "api.foojay.io/disco/v3.0/packages";

    @NotNull
    public final List<Distribution> getDistributions() {
        return this.distributions;
    }

    @Nullable
    public final URI toUri(@Nullable Links links) {
        Links links2 = links;
        return links2 != null ? links2.getPkg_download_redirect() : null;
    }

    @Nullable
    public final Package toPackage(@NotNull JavaLanguageVersion version, @NotNull JvmVendorSpec vendor, @NotNull JvmImplementation implementation, boolean nativeImageCapable, @NotNull OperatingSystem operatingSystem, @NotNull Architecture architecture) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        List<Distribution> distributions = this.match$foojay_resolver(vendor, implementation, version, nativeImageCapable);
        return (Package)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)distributions), (Function1)((Function1)new Function1<Distribution, Package>(this, version, operatingSystem, architecture){
            final /* synthetic */ FoojayApi this$0;
            final /* synthetic */ JavaLanguageVersion $version;
            final /* synthetic */ OperatingSystem $operatingSystem;
            final /* synthetic */ Architecture $architecture;
            {
                this.this$0 = $receiver;
                this.$version = $version;
                this.$operatingSystem = $operatingSystem;
                this.$architecture = $architecture;
                super(1);
            }

            public final Package invoke(Distribution distribution) {
                Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
                return this.this$0.match$foojay_resolver(distribution.getApi_parameter(), this.$version, this.$operatingSystem, this.$architecture);
            }
        })));
    }

    @NotNull
    public final List<Distribution> match$foojay_resolver(@NotNull JvmVendorSpec vendor, @NotNull JvmImplementation implementation, @NotNull JavaLanguageVersion version, boolean nativeImageCapable) {
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.fetchDistributionsIfMissing();
        return DistributionsKt.match(this.distributions, vendor, implementation, version, nativeImageCapable);
    }

    private final void fetchDistributionsIfMissing() {
        if (this.distributions.isEmpty()) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"include_versions", (Object)"true"), TuplesKt.to((Object)"include_synonyms", (Object)"true")};
            HttpURLConnection con = this.createConnection(DISTRIBUTIONS_ENDPOINT, MapsKt.mapOf((Pair[])pairArray));
            String json = this.readResponse(con);
            con.disconnect();
            this.distributions.addAll((Collection<Distribution>)DistributionsKt.parseDistributions(json));
        }
    }

    @Nullable
    public final Package match$foojay_resolver(@NotNull String distributionName, @NotNull JavaLanguageVersion version, @NotNull OperatingSystem operatingSystem, @NotNull Architecture architecture) {
        Intrinsics.checkNotNullParameter((Object)distributionName, (String)"distributionName");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        String versionApiKey = StringsKt.startsWith$default((String)distributionName, (String)"graalvm_community", (boolean)false, (int)2, null) ? "version" : (distributionName.equals("graalvm") ? "version" : "jdk_version");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)versionApiKey, (Object)String.valueOf(version)), TuplesKt.to((Object)"distro", (Object)distributionName), TuplesKt.to((Object)"operating_system", (Object)PackagesKt.toApiValue(operatingSystem)), TuplesKt.to((Object)"latest", (Object)"available"), TuplesKt.to((Object)"directly_downloadable", (Object)"true")};
        HttpURLConnection con = this.createConnection(PACKAGES_ENDPOINT, MapsKt.mapOf((Pair[])pairArray));
        String json = this.readResponse(con);
        con.disconnect();
        List<Package> packages = PackagesKt.parsePackages(json);
        return PackagesKt.match(packages, architecture);
    }

    private final HttpURLConnection createConnection(String endpoint, Map<String, String> parameters) {
        URL url = new URL("https://" + endpoint + '?' + this.toParameterString(parameters));
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection con = (HttpURLConnection)uRLConnection;
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestMethod("GET");
        con.setConnectTimeout(CONNECT_TIMEOUT);
        con.setReadTimeout(READ_TIMEOUT);
        return con;
    }

    private final String toParameterString(Map<String, String> params) {
        return CollectionsKt.joinToString$default((Iterable)params.entrySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)toParameterString.1.INSTANCE, (int)30, null);
    }

    private final String readResponse(HttpURLConnection con) {
        int status = con.getResponseCode();
        if (status != 200) {
            StringBuilder stringBuilder = new StringBuilder().append("Requesting vendor list failed: ");
            InputStream inputStream = con.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"con.errorStream");
            throw new GradleException(stringBuilder.append(this.readContent(inputStream)).toString());
        }
        InputStream inputStream = con.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"con.inputStream");
        return this.readContent(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readContent(InputStream stream) {
        Closeable closeable = stream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader p0 = (BufferedReader)closeable;
            boolean $i$f$readContent$stub_for_inlining = false;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)p0);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gradle/toolchains/foojay/FoojayApi$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "getCONNECT_TIMEOUT", "()I", "DISTRIBUTIONS_ENDPOINT", "", "ENDPOINT_ROOT", "PACKAGES_ENDPOINT", "READ_TIMEOUT", "getREAD_TIMEOUT", "SCHEMA", "foojay-resolver"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCONNECT_TIMEOUT() {
            return CONNECT_TIMEOUT;
        }

        public final int getREAD_TIMEOUT() {
            return READ_TIMEOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

