/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.testsreader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.testretry.org.objectweb.asm.ClassReader;
import org.gradle.testretry.org.objectweb.asm.ClassVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestsReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestsReader.class);
    private final Set<File> testClassesDirs;
    private final Iterable<File> classpath;

    public TestsReader(Set<File> testClassesDirs, Iterable<File> classpath) {
        this.testClassesDirs = testClassesDirs;
        this.classpath = classpath;
    }

    public <R> Optional<R> readTestClassDirClass(String className, Supplier<? extends Visitor<R>> factory) {
        return this.testClassesDirs.stream().map(dir -> new File((File)dir, this.classFileName(className))).filter(File::exists).findFirst().map(file -> this.visitClassFile((File)file, (Visitor)factory.get()));
    }

    public <R> Optional<R> readClass(String className, Supplier<? extends Visitor<R>> factory) {
        Optional<R> opt = this.readTestClassDirClass(className, factory);
        if (opt.isPresent()) {
            return opt;
        }
        return this.readClasspathClass(className, factory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <R> R visitClassFile(File file, Visitor<R> visitor) {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            R r = this.visit(in, visitor);
            return r;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalArgumentException iae) {
            if (!iae.getMessage().startsWith("Unsupported class file major version")) throw iae;
            LOGGER.warn("Could not parse class, ignoring for retry", (Throwable)iae);
            return null;
        }
    }

    private <R> R visit(InputStream in, Visitor<R> visitor) throws IOException {
        ClassReader classReader = new ClassReader(in);
        classReader.accept(visitor, 0);
        return visitor.getResult();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <R> Optional<R> readClasspathClass(String className, Supplier<? extends Visitor<R>> factory) {
        String classFileName = this.classFileName(className);
        for (File file : this.classpath) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File classFile = new File(file, classFileName);
                if (!classFile.exists()) continue;
                return Optional.of(this.visitClassFile(classFile, factory.get()));
            }
            if (!file.getName().endsWith(".jar")) continue;
            try (JarFile jarFile = new JarFile(file);){
                Optional<R> optional;
                block15: {
                    Optional<JarEntry> classFile = jarFile.stream().filter(maybeClass -> maybeClass.getName().equals(classFileName)).findAny();
                    if (!classFile.isPresent()) continue;
                    InputStream is = jarFile.getInputStream(classFile.get());
                    try {
                        optional = Optional.of(this.visit(is, factory.get()));
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return optional;
            }
            catch (IOException iOException) {}
        }
        return Optional.empty();
    }

    @NotNull
    private String classFileName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static abstract class Visitor<T>
    extends ClassVisitor {
        public Visitor() {
            super(458752);
        }

        public abstract T getResult();
    }
}

