/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.testretry.internal.filter.AnnotationInspector;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;

public class AnnotationInspectorImpl
implements AnnotationInspector {
    private static final Logger LOGGER = Logging.getLogger(AnnotationInspectorImpl.class);
    private final Map<String, Set<String>> cache = new HashMap<String, Set<String>>();
    private final Map<String, Boolean> inheritedCache = new HashMap<String, Boolean>();
    private final TestsReader testsReader;

    public AnnotationInspectorImpl(TestsReader testsReader) {
        this.testsReader = testsReader;
    }

    @Override
    public Set<String> getClassAnnotations(String className) {
        Set annotations = this.cache.get(className);
        if (annotations == null) {
            annotations = this.testsReader.readClass(className, () -> new ClassAnnotationVisitor()).orElseGet(() -> {
                LOGGER.warn("Unable to find annotations of " + className);
                return Collections.emptySet();
            });
            this.cache.put(className, annotations);
        }
        return annotations;
    }

    private boolean isInherited(String annotationClassName) {
        return this.inheritedCache.computeIfAbsent(annotationClassName, ignored -> this.testsReader.readClass(annotationClassName, AnnotationAnnotationVisitor::new).orElseGet(() -> {
            LOGGER.warn("Cannot determine whether @" + annotationClassName + " is inherited");
            return false;
        }));
    }

    private static String classDescriptorToClassName(String descriptor) {
        return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
    }

    final class ClassAnnotationVisitor
    extends TestsReader.Visitor<Set<String>> {
        private final Set<String> found = new HashSet<String>();

        ClassAnnotationVisitor() {
        }

        @Override
        public Set<String> getResult() {
            return this.found.isEmpty() ? Collections.emptySet() : this.found;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!superName.equals("java/lang/Object")) {
                AnnotationInspectorImpl.this.getClassAnnotations(superName.replace('/', '.')).stream().filter(x$0 -> AnnotationInspectorImpl.this.isInherited(x$0)).forEach(this.found::add);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            this.found.add(AnnotationInspectorImpl.classDescriptorToClassName(descriptor));
            return null;
        }
    }

    static final class AnnotationAnnotationVisitor
    extends TestsReader.Visitor<Boolean> {
        private boolean inherited;

        AnnotationAnnotationVisitor() {
        }

        @Override
        public Boolean getResult() {
            return this.inherited;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals("Ljava/lang/annotation/Inherited;")) {
                this.inherited = true;
            }
            return null;
        }
    }
}

