/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.testng.TestNGOptions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.testretry.internal.executer.TestFilterBuilder;
import org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.TestFrameworkProvider;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import org.gradle.testretry.internal.executer.framework.TestNgClassVisitor;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TestNgTestFrameworkStrategy
implements TestFrameworkStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestNgTestFrameworkStrategy.class);
    private final Map<String, Optional<TestNgClassVisitor.ClassInfo>> classInfoCache = new HashMap<String, Optional<TestNgClassVisitor.ClassInfo>>();

    TestNgTestFrameworkStrategy() {
    }

    @Override
    public boolean isLifecycleFailureTest(TestsReader testsReader, String className, String testName) {
        return this.getClassInfo(testsReader, className).map(classInfo -> this.isLifecycleMethod(testsReader, testName, (TestNgClassVisitor.ClassInfo)classInfo)).orElse(false);
    }

    private boolean isLifecycleMethod(TestsReader testsReader, String testName, TestNgClassVisitor.ClassInfo classInfo) {
        if (classInfo.getLifecycleMethods().contains(testName)) {
            return true;
        }
        String superClass = classInfo.getSuperClass();
        if (superClass == null || superClass.equals("java.lang.Object")) {
            return false;
        }
        return this.isLifecycleFailureTest(testsReader, superClass, testName);
    }

    @Override
    public TestFramework createRetrying(TestFrameworkTemplate template, TestFramework testFramework, TestNames failedTests, Set<String> testClassesSeenInCurrentRound) {
        DefaultTestFilter failedTestsFilter = this.testFilterFor(failedTests, template);
        return TestNGTestFrameworkProvider.testFrameworkProvider(template, testFramework).testFrameworkFor(failedTestsFilter);
    }

    private DefaultTestFilter testFilterFor(TestNames failedTests, TestFrameworkTemplate template) {
        TestFilterBuilder filter = template.filterBuilder();
        this.addFilters(template.testsReader, failedTests, filter);
        return filter.build();
    }

    private void addFilters(TestsReader testsReader, TestNames failedTests, TestFilterBuilder filters) {
        failedTests.stream().forEach(entry -> {
            String className = (String)entry.getKey();
            Set tests = (Set)entry.getValue();
            if (tests.isEmpty()) {
                filters.clazz(className);
                return;
            }
            Optional<TestNgClassVisitor.ClassInfo> classInfoOpt = this.getClassInfo(testsReader, className);
            tests.forEach(test -> {
                if (classInfoOpt.isPresent()) {
                    TestNgClassVisitor.ClassInfo classInfo = (TestNgClassVisitor.ClassInfo)classInfoOpt.get();
                    if (this.isLifecycleMethod(testsReader, (String)test, classInfo)) {
                        filters.clazz(className);
                    } else {
                        String parameterlessName = TestNgTestFrameworkStrategy.stripParameters(test);
                        filters.test(className, parameterlessName);
                        classInfo.dependsOn(parameterlessName).forEach(methodName -> filters.test(className, (String)methodName));
                    }
                } else {
                    filters.clazz(className);
                }
            });
        });
    }

    private Optional<TestNgClassVisitor.ClassInfo> getClassInfo(TestsReader testsReader, String className) {
        return this.classInfoCache.computeIfAbsent(className, ignored -> {
            Optional<Object> classInfoOpt;
            try {
                classInfoOpt = testsReader.readTestClassDirClass(className, TestNgClassVisitor::new);
            }
            catch (Throwable t) {
                LOGGER.warn("Unable to determine if class " + className + " has TestNG dependent tests", t);
                classInfoOpt = Optional.empty();
            }
            return classInfoOpt;
        });
    }

    private static String stripParameters(String testMethodName) {
        return testMethodName.replaceAll("\\[[^)]+](\\([^)]*\\))+$", "");
    }

    static class TestNGTestFrameworkProvider {
        TestNGTestFrameworkProvider() {
        }

        static void copyOptions(TestNGOptions source, TestNGOptions target) {
            target.setOutputDirectory(source.getOutputDirectory());
            target.setIncludeGroups(source.getIncludeGroups());
            target.setExcludeGroups(source.getExcludeGroups());
            target.setConfigFailurePolicy(source.getConfigFailurePolicy());
            target.setListeners(source.getListeners());
            target.setParallel(source.getParallel());
            target.setThreadCount(source.getThreadCount());
            target.setUseDefaultListeners(source.getUseDefaultListeners());
            target.setSuiteName(source.getSuiteName());
            target.setTestName(source.getTestName());
            target.setSuiteXmlFiles(source.getSuiteXmlFiles());
            target.setPreserveOrder(source.getPreserveOrder());
            target.setGroupByInstances(source.getGroupByInstances());
            target.setSuiteXmlWriter(source.getSuiteXmlWriter());
            target.setSuiteXmlBuilder(source.getSuiteXmlBuilder());
        }

        static TestFrameworkProvider testFrameworkProvider(TestFrameworkTemplate template, TestFramework testFramework) {
            if (TestFrameworkStrategy.gradleVersionIsAtLeast("8.0")) {
                return new TestFrameworkProvider.ProviderForCurrentGradleVersion(testFramework);
            }
            if (TestFrameworkStrategy.gradleVersionIsAtLeast("6.6")) {
                return new ProviderForGradleOlderThanV8(template);
            }
            return new ProviderForGradleOlderThanV66(template);
        }

        static class ProviderForGradleOlderThanV8
        implements TestFrameworkProvider {
            private final TestFrameworkTemplate template;

            public ProviderForGradleOlderThanV8(TestFrameworkTemplate template) {
                this.template = template;
            }

            @Override
            public TestFramework testFrameworkFor(DefaultTestFilter failedTestsFilter) {
                TestNGTestFramework retryTestFramework = ProviderForGradleOlderThanV8.newInstance(this.template, failedTestsFilter);
                TestNGTestFrameworkProvider.copyOptions((TestNGOptions)this.template.task.getTestFramework().getOptions(), retryTestFramework.getOptions());
                return retryTestFramework;
            }

            private static TestNGTestFramework newInstance(TestFrameworkTemplate template, DefaultTestFilter failedTestsFilter) {
                try {
                    Class<TestNGTestFramework> testNGTestFramework = TestNGTestFramework.class;
                    Constructor constructor = testNGTestFramework.getConstructor(Test.class, FileCollection.class, DefaultTestFilter.class, ObjectFactory.class);
                    return (TestNGTestFramework)constructor.newInstance(template.task, template.task.getClasspath(), failedTestsFilter, template.objectFactory);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        static class ProviderForGradleOlderThanV66
        implements TestFrameworkProvider {
            private final TestFrameworkTemplate template;

            public ProviderForGradleOlderThanV66(TestFrameworkTemplate template) {
                this.template = template;
            }

            @Override
            public TestFramework testFrameworkFor(DefaultTestFilter failedTestsFilter) {
                TestNGTestFramework retryTestFramework = this.newInstance(this.template, failedTestsFilter);
                TestNGTestFrameworkProvider.copyOptions((TestNGOptions)this.template.task.getTestFramework().getOptions(), retryTestFramework.getOptions());
                return retryTestFramework;
            }

            private TestNGTestFramework newInstance(TestFrameworkTemplate template, DefaultTestFilter failedTestsFilter) {
                try {
                    ServiceRegistry serviceRegistry = ((ProjectInternal)template.task.getProject()).getServices();
                    ClassLoaderCache classLoaderCache = (ClassLoaderCache)serviceRegistry.get(ClassLoaderCache.class);
                    Class<TestNGTestFramework> testNGTestFramework = TestNGTestFramework.class;
                    Constructor constructor = testNGTestFramework.getConstructor(Test.class, DefaultTestFilter.class, Instantiator.class, ClassLoaderCache.class);
                    return (TestNGTestFramework)constructor.newInstance(template.task, failedTestsFilter, template.instantiator, classLoaderCache);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

