/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testretry.TestRetryTaskExtension;
import org.gradle.testretry.internal.config.DefaultTestRetryTaskExtension;
import org.gradle.testretry.internal.config.TestRetryTaskExtensionAdapter;
import org.gradle.testretry.internal.executer.RetryTestExecuter;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public final class TestTaskConfigurer {
    private static final GradleVersion GRADLE_5_1 = GradleVersion.version((String)"5.1");
    private static final GradleVersion GRADLE_6_1 = GradleVersion.version((String)"6.1");
    private static final String GRADLE_ENTERPRISE_BASE_PACKAGE = "com.gradle.enterprise";

    private TestTaskConfigurer() {
    }

    public static void configureTestTask(Test test, ObjectFactory objectFactory, ProviderFactory providerFactory) {
        TestTaskConfigurer.ensureThatNoRetryExtensionIsPresent(test);
        GradleVersion gradleVersion = GradleVersion.current();
        TestRetryTaskExtension extension = (TestRetryTaskExtension)objectFactory.newInstance(DefaultTestRetryTaskExtension.class, new Object[0]);
        TestRetryTaskExtensionAdapter adapter = new TestRetryTaskExtensionAdapter(providerFactory, extension, gradleVersion);
        test.getInputs().property("retry.failOnPassedAfterRetry", adapter.getFailOnPassedAfterRetryInput());
        test.getInputs().property("retry.failOnSkippedAfterRetry", adapter.getFailOnSkippedAfterRetryInput());
        Provider<Boolean> shouldReplaceTestExecutor = TestTaskConfigurer.shouldReplaceTestExecutor(test, objectFactory, providerFactory, gradleVersion);
        test.getInputs().property("isDeactivatedByTestDistributionPlugin", shouldReplaceTestExecutor);
        test.getExtensions().add(TestRetryTaskExtension.class, "retry", (Object)extension);
        test.doFirst((Action)new ConditionalTaskAction(shouldReplaceTestExecutor, new InitTaskAction(adapter, objectFactory)));
        test.doLast((Action)new ConditionalTaskAction(shouldReplaceTestExecutor, new FinalizeTaskAction()));
    }

    private static void ensureThatNoRetryExtensionIsPresent(Test testTask) {
        Object existingRetryExtension = testTask.getExtensions().findByName("retry");
        if (existingRetryExtension != null) {
            String retryExtensionClassName = existingRetryExtension.getClass().getName();
            if (retryExtensionClassName.startsWith(GRADLE_ENTERPRISE_BASE_PACKAGE)) {
                throw new IllegalStateException("The Develocity Gradle plugin is conflicting with the Test Retry Gradle plugin and has already added a retry extension to the test task " + testTask.getName() + ". Please either remove the Test Retry Gradle plugin from this project or disable the registration of the retry extension in the Develocity Gradle plugin by specifying the system property 'develocity.testretry.enabled' and setting it to 'false'.");
            }
            throw new IllegalStateException("Another plugin is conflicting with the Test Retry Gradle plugin and has already added a retry extension to the test task " + testTask.getName() + ". Please either remove the conflicting plugin or the Test Retry Gradle plugin from this test project.");
        }
    }

    private static Provider<Boolean> shouldReplaceTestExecutor(Test test, ObjectFactory objectFactory, ProviderFactory providerFactory, GradleVersion gradleVersion) {
        Provider result = providerFactory.provider(() -> TestTaskConfigurer.callShouldTestRetryPluginBeDeactivated(test));
        if (TestTaskConfigurer.supportsPropertyConventions(gradleVersion)) {
            Property property = objectFactory.property(Boolean.class).convention(result);
            if (TestTaskConfigurer.supportsFinalizeValueOnRead(gradleVersion)) {
                property.finalizeValueOnRead();
            }
            result = property;
        }
        return result;
    }

    public static boolean supportsPropertyConventions(GradleVersion gradleVersion) {
        return gradleVersion.compareTo(GRADLE_5_1) >= 0;
    }

    private static boolean supportsFinalizeValueOnRead(GradleVersion gradleVersion) {
        return gradleVersion.compareTo(GRADLE_6_1) >= 0;
    }

    private static boolean callShouldTestRetryPluginBeDeactivated(Test test) {
        Object develocityExtension = test.getExtensions().findByName("develocity");
        if (develocityExtension == null) {
            return TestTaskConfigurer.callShouldTestRetryPluginBeDeactivatedOnDistributionExtension(test);
        }
        try {
            Object testRetryConfiguration = TestTaskConfigurer.invoke(develocityExtension, TestTaskConfigurer.makeAccessible(develocityExtension.getClass().getMethod("getTestRetry", new Class[0])), new Object[0]);
            return (Boolean)TestTaskConfigurer.invoke(testRetryConfiguration, TestTaskConfigurer.makeAccessible(testRetryConfiguration.getClass().getMethod("shouldTestRetryPluginBeDeactivated", new Class[0])), new Object[0]);
        }
        catch (Exception e) {
            test.getLogger().warn("Failed to determine whether test-retry plugin should be deactivated from testRetry configuration on develocity extension", (Throwable)e);
            return false;
        }
    }

    private static boolean callShouldTestRetryPluginBeDeactivatedOnDistributionExtension(Test test) {
        Object distributionExtension = test.getExtensions().findByName("distribution");
        if (distributionExtension == null) {
            return false;
        }
        try {
            return (Boolean)TestTaskConfigurer.invoke(distributionExtension, TestTaskConfigurer.makeAccessible(distributionExtension.getClass().getMethod("shouldTestRetryPluginBeDeactivated", new Class[0])), new Object[0]);
        }
        catch (Exception e) {
            test.getLogger().warn("Failed to determine whether test-retry plugin should be deactivated from distribution extension", (Throwable)e);
            return false;
        }
    }

    private static RetryTestExecuter createRetryTestExecuter(Test task, TestRetryTaskExtensionAdapter extension, ObjectFactory objectFactory) {
        TestExecuter<JvmTestExecutionSpec> delegate = TestTaskConfigurer.getTestExecuter(task);
        Instantiator instantiator = (Instantiator)TestTaskConfigurer.invoke(task, TestTaskConfigurer.declaredMethod(AbstractTestTask.class, "getInstantiator", new Class[0]), new Object[0]);
        return new RetryTestExecuter(task, extension, delegate, instantiator, objectFactory, task.getTestClassesDirs().getFiles(), task.getClasspath().getFiles());
    }

    private static TestExecuter<JvmTestExecutionSpec> getTestExecuter(Test task) {
        return (TestExecuter)TestTaskConfigurer.invoke(task, TestTaskConfigurer.declaredMethod(Test.class, "createTestExecuter", new Class[0]), new Object[0]);
    }

    private static void setTestExecuter(Test task, RetryTestExecuter retryTestExecuter) {
        TestTaskConfigurer.invoke(task, TestTaskConfigurer.declaredMethod(Test.class, "setTestExecuter", TestExecuter.class), retryTestExecuter);
    }

    private static Method declaredMethod(Class<?> type, String methodName, Class<?> ... paramTypes) {
        try {
            return TestTaskConfigurer.makeAccessible(type.getDeclaredMethod(methodName, paramTypes));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    private static <T> T invoke(Object instance, Method method, Object ... args) {
        try {
            Object result;
            Object cast = result = method.invoke(instance, args);
            return (T)cast;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ConditionalTaskAction
    implements Action<Task> {
        private final Provider<Boolean> shouldReplaceTestExecutor;
        private final Action<Test> delegate;

        public ConditionalTaskAction(Provider<Boolean> shouldReplaceTestExecutor, Action<Test> delegate) {
            this.shouldReplaceTestExecutor = shouldReplaceTestExecutor;
            this.delegate = delegate;
        }

        public void execute(@NotNull Task task) {
            if (((Boolean)this.shouldReplaceTestExecutor.get()).booleanValue()) {
                task.getLogger().info("Test execution via the test-retry plugin is deactivated. Retries are handled by the Develocity plugin.");
            } else {
                this.delegate.execute((Object)((Test)task));
            }
        }
    }

    private static class InitTaskAction
    implements Action<Test> {
        private final TestRetryTaskExtensionAdapter adapter;
        private final ObjectFactory objectFactory;

        public InitTaskAction(TestRetryTaskExtensionAdapter adapter, ObjectFactory objectFactory) {
            this.adapter = adapter;
            this.objectFactory = objectFactory;
        }

        public void execute(@NotNull Test task) {
            RetryTestExecuter retryTestExecuter = TestTaskConfigurer.createRetryTestExecuter(task, this.adapter, this.objectFactory);
            TestTaskConfigurer.setTestExecuter(task, retryTestExecuter);
        }
    }

    private static class FinalizeTaskAction
    implements Action<Test> {
        private FinalizeTaskAction() {
        }

        public void execute(@NotNull Test task) {
            TestExecuter testExecuter = TestTaskConfigurer.getTestExecuter(task);
            if (!(testExecuter instanceof RetryTestExecuter)) {
                throw new IllegalStateException("Unexpected test executer: " + testExecuter);
            }
            ((RetryTestExecuter)testExecuter).failWithNonRetriedTestsIfAny();
        }
    }
}

