/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.config;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.testretry.TestRetryTaskExtension;
import org.gradle.testretry.internal.config.TestRetryTaskExtensionAccessor;
import org.gradle.testretry.internal.config.TestTaskConfigurer;
import org.gradle.util.GradleVersion;

public final class TestRetryTaskExtensionAdapter
implements TestRetryTaskExtensionAccessor {
    public static final String SIMULATE_NOT_RETRYABLE_PROPERTY = "__org_gradle_testretry_simulate_not_retryable";
    private static final int DEFAULT_MAX_RETRIES = 0;
    private static final int DEFAULT_MAX_FAILURES = 0;
    private static final boolean DEFAULT_FAIL_ON_PASSED_AFTER_RETRY = false;
    private static final boolean DEFAULT_FAIL_ON_SKIPPED_AFTER_RETRY = true;
    private final ProviderFactory providerFactory;
    private final TestRetryTaskExtension extension;
    private final boolean simulateNotRetryableTest;
    private final boolean useConventions;

    public TestRetryTaskExtensionAdapter(ProviderFactory providerFactory, TestRetryTaskExtension extension, GradleVersion gradleVersion) {
        this.providerFactory = providerFactory;
        this.extension = extension;
        this.simulateNotRetryableTest = Boolean.getBoolean(SIMULATE_NOT_RETRYABLE_PROPERTY);
        this.useConventions = TestTaskConfigurer.supportsPropertyConventions(gradleVersion);
        TestRetryTaskExtensionAdapter.initialize(extension, this.useConventions);
    }

    private static void initialize(TestRetryTaskExtension extension, boolean gradle51OrLater) {
        TestRetryTaskExtension.Filter filter = extension.getFilter();
        TestRetryTaskExtension.ClassRetryCriteria classRetry = extension.getClassRetry();
        if (gradle51OrLater) {
            extension.getMaxRetries().convention((Object)0);
            extension.getMaxFailures().convention((Object)0);
            extension.getFailOnPassedAfterRetry().convention((Object)false);
            extension.getFailOnSkippedAfterRetry().convention((Object)true);
            filter.getIncludeClasses().convention(Collections.emptySet());
            filter.getIncludeAnnotationClasses().convention(Collections.emptySet());
            filter.getExcludeClasses().convention(Collections.emptySet());
            filter.getExcludeAnnotationClasses().convention(Collections.emptySet());
            classRetry.getIncludeClasses().convention(Collections.emptySet());
            classRetry.getIncludeAnnotationClasses().convention(Collections.emptySet());
        } else {
            filter.getIncludeClasses().empty();
            filter.getIncludeAnnotationClasses().empty();
            filter.getExcludeClasses().empty();
            filter.getExcludeAnnotationClasses().empty();
            classRetry.getIncludeClasses().empty();
            classRetry.getIncludeAnnotationClasses().empty();
        }
    }

    Callable<Provider<Boolean>> getFailOnPassedAfterRetryInput() {
        if (this.useConventions) {
            return this.extension::getFailOnPassedAfterRetry;
        }
        return () -> {
            if (this.extension.getFailOnPassedAfterRetry().isPresent()) {
                return this.extension.getFailOnPassedAfterRetry();
            }
            return this.providerFactory.provider(this::getFailOnPassedAfterRetry);
        };
    }

    Callable<Provider<Boolean>> getFailOnSkippedAfterRetryInput() {
        if (this.useConventions) {
            return this.extension::getFailOnSkippedAfterRetry;
        }
        return () -> {
            if (this.extension.getFailOnSkippedAfterRetry().isPresent()) {
                return this.extension.getFailOnSkippedAfterRetry();
            }
            return this.providerFactory.provider(this::getFailOnSkippedAfterRetry);
        };
    }

    @Override
    public boolean getFailOnPassedAfterRetry() {
        return this.read(this.extension.getFailOnPassedAfterRetry(), false);
    }

    @Override
    public boolean getFailOnSkippedAfterRetry() {
        return this.read(this.extension.getFailOnSkippedAfterRetry(), true);
    }

    @Override
    public int getMaxRetries() {
        return this.read(this.extension.getMaxRetries(), 0);
    }

    @Override
    public int getMaxFailures() {
        return this.read(this.extension.getMaxFailures(), 0);
    }

    @Override
    public Set<String> getIncludeClasses() {
        return this.read(this.extension.getFilter().getIncludeClasses(), Collections.emptySet());
    }

    @Override
    public Set<String> getIncludeAnnotationClasses() {
        return this.read(this.extension.getFilter().getIncludeAnnotationClasses(), Collections.emptySet());
    }

    @Override
    public Set<String> getExcludeClasses() {
        return this.read(this.extension.getFilter().getExcludeClasses(), Collections.emptySet());
    }

    @Override
    public Set<String> getExcludeAnnotationClasses() {
        return this.read(this.extension.getFilter().getExcludeAnnotationClasses(), Collections.emptySet());
    }

    @Override
    public Set<String> getClassRetryIncludeClasses() {
        return this.read(this.extension.getClassRetry().getIncludeClasses(), Collections.emptySet());
    }

    @Override
    public Set<String> getClassRetryIncludeAnnotationClasses() {
        return this.read(this.extension.getClassRetry().getIncludeAnnotationClasses(), Collections.emptySet());
    }

    @Override
    public boolean getSimulateNotRetryableTest() {
        return this.simulateNotRetryableTest;
    }

    private <T> T read(Property<T> property, T defaultValue) {
        return (T)(this.useConventions ? property.get() : property.getOrElse(defaultValue));
    }

    private <T> Set<T> read(SetProperty<T> property, Set<T> defaultValue) {
        return this.useConventions ? (Set)property.get() : (Set)property.getOrElse(defaultValue);
    }
}

