/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.filter;

import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class GlobPattern {
    public static final Pattern STAR_CHAR_PATTERN = Pattern.compile("\\*");
    public static final String MATCH_ANY = ".*?";
    private final String string;
    private final Pattern pattern;

    private GlobPattern(String string, Pattern pattern) {
        this.string = string;
        this.pattern = pattern;
    }

    static GlobPattern from(String string) {
        String patternString = STAR_CHAR_PATTERN.splitAsStream(string).map(Pattern::quote).collect(Collectors.joining(MATCH_ANY));
        if (string.endsWith("*")) {
            patternString = patternString + MATCH_ANY;
        }
        Pattern pattern = Pattern.compile(patternString);
        return new GlobPattern(patternString, pattern);
    }

    boolean matches(String test) {
        return this.pattern.matcher(test).matches();
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobPattern that = (GlobPattern)o;
        return this.string.equals(that.string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

