/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.testretry.internal.filter.AnnotationInspector;
import org.gradle.testretry.internal.filter.GlobPattern;

public class ClassRetryMatcher {
    private static final List<String> IMPLICIT_INCLUDE_ANNOTATION_CLASSES = Collections.unmodifiableList(Arrays.asList("spock.lang.Stepwise", "com.gradle.enterprise.testing.annotations.ClassRetry", "com.gradle.develocity.testing.annotations.ClassRetry"));
    private final AnnotationInspector annotationInspector;
    private final Set<GlobPattern> includeClasses;
    private final Set<GlobPattern> includeAnnotationClasses;

    public ClassRetryMatcher(AnnotationInspector annotationInspector, Collection<String> includeClasses, Collection<String> includeAnnotationClasses) {
        HashSet<String> mergedIncludeAnnotationClasses = new HashSet<String>(IMPLICIT_INCLUDE_ANNOTATION_CLASSES);
        mergedIncludeAnnotationClasses.addAll(includeAnnotationClasses);
        this.annotationInspector = annotationInspector;
        this.includeClasses = ClassRetryMatcher.toPatterns(includeClasses);
        this.includeAnnotationClasses = ClassRetryMatcher.toPatterns(mergedIncludeAnnotationClasses);
    }

    public boolean retryWholeClass(String className) {
        if (ClassRetryMatcher.anyMatch(this.includeClasses, className)) {
            return true;
        }
        if (!this.includeAnnotationClasses.isEmpty()) {
            Set<String> annotations = this.annotationInspector.getClassAnnotations(className);
            return !annotations.isEmpty() && ClassRetryMatcher.anyMatch(this.includeAnnotationClasses, annotations);
        }
        return false;
    }

    private static boolean anyMatch(Set<GlobPattern> patterns, String string) {
        return ClassRetryMatcher.anyMatch(patterns, Collections.singleton(string));
    }

    private static boolean anyMatch(Set<GlobPattern> patterns, Set<String> strings) {
        return patterns.stream().anyMatch(p -> strings.stream().anyMatch(p::matches));
    }

    private static Set<GlobPattern> toPatterns(Collection<String> strings) {
        return strings.stream().map(GlobPattern::from).collect(Collectors.toSet());
    }
}

