/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer;

import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testretry.internal.config.TestRetryTaskExtensionAccessor;
import org.gradle.testretry.internal.executer.JvmTestExecutionSpecFactory;
import org.gradle.testretry.internal.executer.RetryTestResultProcessor;
import org.gradle.testretry.internal.executer.RoundResult;
import org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import org.gradle.testretry.internal.filter.AnnotationInspectorImpl;
import org.gradle.testretry.internal.filter.ClassRetryMatcher;
import org.gradle.testretry.internal.filter.RetryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryTestExecuter
implements TestExecuter<JvmTestExecutionSpec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryTestExecuter.class);
    private final TestRetryTaskExtensionAccessor extension;
    private final TestExecuter<JvmTestExecutionSpec> delegate;
    private final Test testTask;
    private final TestFrameworkTemplate frameworkTemplate;
    private RoundResult lastResult;

    public RetryTestExecuter(Test task, TestRetryTaskExtensionAccessor extension, TestExecuter<JvmTestExecutionSpec> delegate, Instantiator instantiator, ObjectFactory objectFactory, Set<File> testClassesDir, Set<File> resolvedClasspath) {
        this.extension = extension;
        this.delegate = delegate;
        this.testTask = task;
        this.frameworkTemplate = new TestFrameworkTemplate(this.testTask, instantiator, objectFactory, testClassesDir, resolvedClasspath);
    }

    public void execute(JvmTestExecutionSpec spec, TestResultProcessor testResultProcessor) {
        int maxRetries = this.extension.getMaxRetries();
        int maxFailures = this.extension.getMaxFailures();
        boolean failOnPassedAfterRetry = this.extension.getFailOnPassedAfterRetry();
        boolean failOnSkippedAfterRetry = this.extension.getFailOnSkippedAfterRetry();
        if (maxRetries <= 0) {
            this.delegate.execute((TestExecutionSpec)spec, testResultProcessor);
            return;
        }
        TestFrameworkStrategy testFrameworkStrategy = TestFrameworkStrategy.of(spec);
        if (testFrameworkStrategy == null) {
            LOGGER.warn("Test retry requested for task {} with unsupported test framework {} - failing tests will not be retried", (Object)spec.getIdentityPath(), (Object)spec.getTestFramework().getClass().getName());
            this.delegate.execute((TestExecutionSpec)spec, testResultProcessor);
            return;
        }
        AnnotationInspectorImpl annotationInspector = new AnnotationInspectorImpl(this.frameworkTemplate.testsReader);
        RetryFilter filter = new RetryFilter(annotationInspector, this.extension.getIncludeClasses(), this.extension.getIncludeAnnotationClasses(), this.extension.getExcludeClasses(), this.extension.getExcludeAnnotationClasses());
        ClassRetryMatcher classRetryMatcher = new ClassRetryMatcher(annotationInspector, this.extension.getClassRetryIncludeClasses(), this.extension.getClassRetryIncludeAnnotationClasses());
        RetryTestResultProcessor retryTestResultProcessor = new RetryTestResultProcessor(testFrameworkStrategy, filter, classRetryMatcher, this.frameworkTemplate.testsReader, testResultProcessor, maxFailures, failOnSkippedAfterRetry);
        int retryCount = 0;
        JvmTestExecutionSpec testExecutionSpec = spec;
        while (true) {
            RoundResult result;
            this.delegate.execute((TestExecutionSpec)testExecutionSpec, (TestResultProcessor)retryTestResultProcessor);
            this.lastResult = result = retryTestResultProcessor.getResult();
            if (this.extension.getSimulateNotRetryableTest() || !result.nonRetriedTests.isEmpty()) {
                this.testTask.setIgnoreFailures(true);
                break;
            }
            if (result.failedTests.isEmpty()) {
                if (retryCount <= 0 || result.hasRetryFilteredFailures || failOnPassedAfterRetry) break;
                this.testTask.setIgnoreFailures(true);
                break;
            }
            if (result.lastRound) break;
            TestFramework retryTestFramework = testFrameworkStrategy.createRetrying(this.frameworkTemplate, spec.getTestFramework(), result.failedTests, result.testClassesSeenInCurrentRound);
            testExecutionSpec = JvmTestExecutionSpecFactory.testExecutionSpecFor(retryTestFramework, spec);
            retryTestResultProcessor.reset(++retryCount == maxRetries);
        }
    }

    public void failWithNonRetriedTestsIfAny() {
        if (this.extension.getSimulateNotRetryableTest() || this.hasNonRetriedTests()) {
            throw new IllegalStateException("The following test methods could not be retried, which is unexpected. Please file a bug report at https://github.com/gradle/test-retry-gradle-plugin/issues" + this.lastResult.nonRetriedTests.stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(methodName -> "   " + (String)entry.getKey() + "#" + methodName)).collect(Collectors.joining("\n", "\n", "\n")));
        }
    }

    private boolean hasNonRetriedTests() {
        return this.lastResult != null && !this.lastResult.nonRetriedTests.isEmpty();
    }

    public void stopNow() {
        this.delegate.stopNow();
    }
}

