/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer;

import java.lang.reflect.Constructor;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;

enum JvmTestExecutionSpecFactory {
    FACTORY_FOR_CURRENT_GRADLE_VERSION{

        @Override
        JvmTestExecutionSpec createExecutionSpec(TestFramework testFramework, JvmTestExecutionSpec source) {
            return source.copyWithTestFramework(testFramework);
        }
    }
    ,
    FACTORY_FOR_GRADLE_OLDER_THAN_V8{

        @Override
        JvmTestExecutionSpec createExecutionSpec(TestFramework testFramework, JvmTestExecutionSpec source) {
            try {
                Class<JvmTestExecutionSpec> clazz = JvmTestExecutionSpec.class;
                Constructor constructor = clazz.getConstructor(TestFramework.class, Iterable.class, Iterable.class, FileTree.class, Boolean.TYPE, FileCollection.class, String.class, Path.class, Long.TYPE, JavaForkOptions.class, Integer.TYPE, Set.class);
                return (JvmTestExecutionSpec)constructor.newInstance(testFramework, source.getClasspath(), source.getModulePath(), source.getCandidateClassFiles(), source.isScanForTestClasses(), source.getTestClassesDirs(), source.getPath(), source.getIdentityPath(), source.getForkEvery(), source.getJavaForkOptions(), source.getMaxParallelForks(), source.getPreviousFailedTestClasses());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    FACTORY_FOR_GRADLE_OLDER_THAN_V6_4{

        @Override
        JvmTestExecutionSpec createExecutionSpec(TestFramework testFramework, JvmTestExecutionSpec source) {
            try {
                Class<JvmTestExecutionSpec> clazz = JvmTestExecutionSpec.class;
                Constructor constructor = clazz.getConstructor(TestFramework.class, Iterable.class, FileTree.class, Boolean.TYPE, FileCollection.class, String.class, Path.class, Long.TYPE, JavaForkOptions.class, Integer.TYPE, Set.class);
                return (JvmTestExecutionSpec)constructor.newInstance(testFramework, source.getClasspath(), source.getCandidateClassFiles(), source.isScanForTestClasses(), source.getTestClassesDirs(), source.getPath(), source.getIdentityPath(), source.getForkEvery(), source.getJavaForkOptions(), source.getMaxParallelForks(), source.getPreviousFailedTestClasses());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    };


    abstract JvmTestExecutionSpec createExecutionSpec(TestFramework var1, JvmTestExecutionSpec var2);

    static JvmTestExecutionSpec testExecutionSpecFor(TestFramework testFramework, JvmTestExecutionSpec source) {
        JvmTestExecutionSpecFactory factory = JvmTestExecutionSpecFactory.getInstance();
        return factory.createExecutionSpec(testFramework, source);
    }

    private static JvmTestExecutionSpecFactory getInstance() {
        if (JvmTestExecutionSpecFactory.gradleVersionIsAtLeast("8.0")) {
            return FACTORY_FOR_CURRENT_GRADLE_VERSION;
        }
        if (JvmTestExecutionSpecFactory.gradleVersionIsAtLeast("6.4")) {
            return FACTORY_FOR_GRADLE_OLDER_THAN_V8;
        }
        return FACTORY_FOR_GRADLE_OLDER_THAN_V6_4;
    }

    private static boolean gradleVersionIsAtLeast(String version) {
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)version)) >= 0;
    }
}

