/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.routes;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.gradle.playframework.tools.internal.routes.RoutesCompileSpec;
import org.gradle.playframework.util.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRoutesPostProcessor
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRoutesPostProcessor.class);

    DefaultRoutesPostProcessor() {
    }

    void execute(RoutesCompileSpec spec) {
        String sourceReplacementString = this.getSourceReplacementString(spec.getSources(), spec.getProjectDir());
        try (Stream<Path> stream = Files.find(spec.getDestinationDir().toPath(), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
            stream.forEach(routeFile -> this.process((Path)routeFile, sourceReplacementString));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to post-process files", (Throwable)e);
        }
    }

    private String getSourceReplacementString(Iterable<File> sources, File projectDir) {
        String sourceReplacementString = "";
        if (sources.iterator().hasNext()) {
            File sourceFile = sources.iterator().next();
            sourceReplacementString = "// @(SOURCE):" + PathUtil.relativePath(projectDir, sourceFile);
        }
        return sourceReplacementString;
    }

    private void process(Path routeFile, String sourceReplacementString) {
        try {
            String content = new String(Files.readAllBytes(routeFile), StandardCharsets.UTF_8);
            content = content.replaceAll("(?m)^// @(SOURCE):.*", sourceReplacementString);
            content = content.replaceAll("(?m)^// @(DATE):.*", "");
            Files.write(routeFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Unable to post-process file %s", routeFile.getFileName()), (Throwable)e);
        }
    }
}

