/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins.internal;

import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.GradleVersion;

public final class PlayPluginHelper {
    private PlayPluginHelper() {
    }

    public static SourceSet getMainJavaSourceSet(Project project) {
        return PlayPluginHelper.getSourceSet(project, "main");
    }

    public static SourceSet getTestJavaSourceSet(Project project) {
        return PlayPluginHelper.getSourceSet(project, "test");
    }

    private static SourceSet getSourceSet(Project project, String sourceSetName) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        return (SourceSet)javaPluginExtension.getSourceSets().getByName(sourceSetName);
    }

    public static SourceDirectorySet getMainScalaSourceDirectorySet(Project project) {
        return PlayPluginHelper.getScalaSourceDirectorySet(PlayPluginHelper.getMainJavaSourceSet(project));
    }

    public static SourceDirectorySet getTestScalaSourceDirectorySet(Project project) {
        return PlayPluginHelper.getScalaSourceDirectorySet(PlayPluginHelper.getTestJavaSourceSet(project));
    }

    private static SourceDirectorySet getScalaSourceDirectorySet(SourceSet sourceSet) {
        try {
            return (SourceDirectorySet)sourceSet.getExtensions().getByName("scala");
        }
        catch (Exception e) {
            return (SourceDirectorySet)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getScala", null);
        }
    }

    public static <T extends SourceDirectorySet> T createCustomSourceDirectorySet(Project project, String name, Class<? extends T> sourceDirectorySetType8, Class<? extends T> sourceDirectorySetTypeBefore8) {
        SourceSet mainJavaSourceSet = PlayPluginHelper.getMainJavaSourceSet(project);
        Class<? extends T> sourceDirectorySetType = PlayPluginHelper.selectGradleVersionCompatibleType(sourceDirectorySetType8, sourceDirectorySetTypeBefore8);
        SourceDirectorySet sourceDirectorySet = (SourceDirectorySet)project.getObjects().newInstance(sourceDirectorySetType, new Object[]{project.getObjects().sourceDirectorySet(name, ((DefaultSourceSet)mainJavaSourceSet).getDisplayName())});
        mainJavaSourceSet.getExtensions().add(name, (Object)sourceDirectorySet);
        return (T)sourceDirectorySet;
    }

    private static <T> Class<? extends T> selectGradleVersionCompatibleType(Class<? extends T> typeForGradle8Plus, Class<? extends T> typeForOlderGradle) {
        boolean isGradle8OrNewer = GradleVersion.current().compareTo(GradleVersion.version((String)"8.0")) >= 0;
        return isGradle8OrNewer ? typeForGradle8Plus : typeForOlderGradle;
    }
}

