/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins;

import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.playframework.plugins.PlayGeneratedSourcePlugin;
import org.gradle.playframework.plugins.internal.DefaultPlaySourceDirectorySet8;
import org.gradle.playframework.plugins.internal.DefaultPlaySourceDirectorySetBefore8;
import org.gradle.playframework.plugins.internal.PlayPluginHelper;
import org.gradle.playframework.tasks.JavaScriptMinify;
import org.gradle.playframework.tools.internal.javascript.GoogleClosureCompiler;

public class PlayJavaScriptPlugin
implements PlayGeneratedSourcePlugin {
    public static final String COMPILER_CONFIGURATION_NAME = "javaScriptCompiler";
    public static final String JS_MINIFY_TASK_NAME = "minifyPlayJavaScript";

    public void apply(Project project) {
        Configuration compilerConfiguration = this.createCompilerConfiguration(project);
        this.declareDefaultDependencies(project, compilerConfiguration);
        DefaultPlaySourceDirectorySetBefore8 javaScript = PlayPluginHelper.createCustomSourceDirectorySet(project, "javaScript", DefaultPlaySourceDirectorySet8.class, DefaultPlaySourceDirectorySetBefore8.class);
        javaScript.srcDirs(new Object[]{"app/assets"});
        javaScript.include(new String[]{"**/*.js"});
        this.createDefaultJavaScriptMinifyTask(project, (SourceDirectorySet)javaScript, compilerConfiguration);
    }

    private Configuration createCompilerConfiguration(Project project) {
        Configuration compilerConfiguration = (Configuration)project.getConfigurations().create(COMPILER_CONFIGURATION_NAME);
        compilerConfiguration.setVisible(false);
        compilerConfiguration.setTransitive(true);
        compilerConfiguration.setDescription("The JavaScript compiler library used to minify assets.");
        return compilerConfiguration;
    }

    private void declareDefaultDependencies(Project project, Configuration configuration) {
        configuration.defaultDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create(GoogleClosureCompiler.getDependencyNotation())));
    }

    private void createDefaultJavaScriptMinifyTask(Project project, SourceDirectorySet sourceDirectory, Configuration compilerConfiguration) {
        project.getTasks().register(JS_MINIFY_TASK_NAME, JavaScriptMinify.class, javaScriptMinify -> {
            javaScriptMinify.setDescription("Minifies javascript for the " + sourceDirectory.getDisplayName() + ".");
            javaScriptMinify.getDestinationDir().set(this.getOutputDir(project, sourceDirectory));
            javaScriptMinify.setSource((FileTree)sourceDirectory);
            javaScriptMinify.getCompilerClasspath().setFrom((Iterable)compilerConfiguration);
            javaScriptMinify.dependsOn(new Object[]{sourceDirectory});
        });
    }
}

