/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.routes;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.playframework.tools.internal.Compiler;
import org.gradle.playframework.tools.internal.routes.DefaultRoutesPostProcessor;
import org.gradle.playframework.tools.internal.routes.RoutesCompileSpec;
import org.gradle.playframework.tools.internal.routes.VersionedRoutesCompilerAdapter;
import org.gradle.playframework.tools.internal.scala.ScalaMethod;

public class RoutesCompiler
implements Compiler<RoutesCompileSpec>,
Serializable {
    private final VersionedRoutesCompilerAdapter adapter;
    private final DefaultRoutesPostProcessor postProcessor;

    public RoutesCompiler(VersionedRoutesCompilerAdapter adapter) {
        this.adapter = adapter;
        this.postProcessor = new DefaultRoutesPostProcessor();
    }

    @Override
    public WorkResult execute(RoutesCompileSpec spec) {
        Boolean ret;
        boolean didWork = false;
        ArrayList<File> primaryRoutes = new ArrayList<File>();
        ArrayList<File> secondaryRoutes = new ArrayList<File>();
        for (File source : spec.getSources()) {
            if (source.getName().equals("routes")) {
                primaryRoutes.add(source);
                continue;
            }
            secondaryRoutes.add(source);
        }
        for (File sourceFile : secondaryRoutes) {
            ret = this.compile(sourceFile, spec);
            didWork = ret != false || didWork;
        }
        for (File sourceFile : primaryRoutes) {
            ret = this.compile(sourceFile, spec);
            didWork = ret != false || didWork;
        }
        this.postProcessor.execute(spec);
        return WorkResults.didWork((boolean)didWork);
    }

    private Boolean compile(File sourceFile, RoutesCompileSpec spec) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            ScalaMethod compile = this.adapter.getCompileMethod(cl);
            return this.adapter.interpretResult(compile.invoke(this.adapter.createCompileParameters(cl, sourceFile, spec.getDestinationDir(), spec.isJavaProject(), spec.isNamespaceReverseRouter(), spec.isGenerateReverseRoutes(), spec.isInjectedRoutesGenerator(), spec.getAdditionalImports())));
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking the Play routes compiler.", e);
        }
    }

    public Object getDependencyNotation() {
        return this.adapter.getDependencyNotation();
    }

    public Iterable<String> getClassLoaderPackages() {
        return this.adapter.getClassLoaderPackages();
    }
}

