/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.playframework.plugins.PlayApplicationPlugin;
import org.gradle.playframework.plugins.PlayDistributionPlugin;
import org.gradle.playframework.plugins.PlayIdePlugin;
import org.gradle.playframework.plugins.PlayJavaScriptPlugin;
import org.gradle.playframework.tasks.JavaScriptMinify;

public class PlayPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        PlayPlugin.applyPlugins(project);
        PlayPlugin.configureJavaScriptTasks(project);
    }

    private static void applyPlugins(Project project) {
        project.getPluginManager().apply(PlayApplicationPlugin.class);
        project.getPluginManager().apply(PlayJavaScriptPlugin.class);
        project.getPluginManager().apply(PlayDistributionPlugin.class);
        project.getPluginManager().apply(PlayIdePlugin.class);
    }

    private static void configureJavaScriptTasks(Project project) {
        TaskProvider javaScriptMinifyTask = project.getTasks().named("minifyPlayJavaScript", JavaScriptMinify.class);
        project.getTasks().named("assemble", task -> task.dependsOn(new Object[]{javaScriptMinifyTask}));
        project.getTasks().named("createPlayAssetsJar", Jar.class, task -> {
            task.dependsOn(new Object[]{javaScriptMinifyTask});
            task.from(((JavaScriptMinify)((Object)((Object)javaScriptMinifyTask.get()))).getDestinationDir(), copySpec -> copySpec.into((Object)"public"));
        });
    }
}

