/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins;

import java.io.File;
import java.util.HashSet;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.playframework.extensions.PlayExtension;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.plugins.internal.PlayPluginHelper;
import org.gradle.playframework.tasks.JavaScriptMinify;
import org.gradle.playframework.tasks.RoutesCompile;
import org.gradle.playframework.tasks.TwirlCompile;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModule;

public class PlayIdeaPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().named("ideaModule", GenerateIdeaModule.class, ideaModuleTask -> {
            IdeaModule module = ideaModuleTask.getModule();
            ConventionMapping conventionMapping = this.conventionMappingFor(module);
            TaskProvider javaScriptMinifyTask = project.getTasks().named("minifyPlayJavaScript", JavaScriptMinify.class);
            conventionMapping.map("sourceDirs", () -> {
                HashSet<File> sourceDirs = new HashSet<File>();
                sourceDirs.add(new File(project.getProjectDir(), "public"));
                SourceDirectorySet scalaSourceDirectorySet = PlayPluginHelper.getMainScalaSourceDirectorySet(project);
                sourceDirs.addAll(scalaSourceDirectorySet.getSrcDirs());
                sourceDirs.add(((Directory)((JavaScriptMinify)((Object)((Object)((Object)javaScriptMinifyTask.get())))).getDestinationDir().get()).getAsFile());
                return sourceDirs;
            });
            PlayExtension playExtension = (PlayExtension)project.getExtensions().getByName("play");
            conventionMapping.map("targetBytecodeVersion", () -> this.getTargetJavaVersion(playExtension.getPlatform()));
            conventionMapping.map("languageLevel", () -> new IdeaLanguageLevel((Object)this.getTargetJavaVersion(playExtension.getPlatform())));
            ideaModuleTask.dependsOn(new Object[]{javaScriptMinifyTask});
            ideaModuleTask.dependsOn(new Object[]{project.getTasks().withType(TwirlCompile.class)});
            ideaModuleTask.dependsOn(new Object[]{project.getTasks().withType(RoutesCompile.class)});
        });
    }

    private ConventionMapping conventionMappingFor(IdeaModule module) {
        return new DslObject((Object)module).getConventionMapping();
    }

    private JavaVersion getTargetJavaVersion(PlayPlatform platform) {
        return (JavaVersion)platform.getJavaVersion().get();
    }
}

