/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Pair;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new AssertionError((Object)"No org.gradle.playframework.util.CollectionUtils instances for you!");
    }

    @Nullable
    public static <T> T findFirst(Iterable<? extends T> source, Spec<? super T> filter) {
        for (T item : source) {
            if (!filter.isSatisfiedBy(item)) continue;
            return item;
        }
        return null;
    }

    public static <R, I> List<R> collect(Iterable<? extends I> source, Transformer<? extends R, ? super I> transformer) {
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            return CollectionUtils.collect(source, new ArrayList(collection.size()), transformer);
        }
        return CollectionUtils.collect(source, new LinkedList(), transformer);
    }

    public static <R, I, C extends Collection<R>> C collect(Iterable<? extends I> source, C destination, Transformer<? extends R, ? super I> transformer) {
        for (I item : source) {
            destination.add((Object)transformer.transform(item));
        }
        return destination;
    }

    public static List<?> flattenCollections(Object ... things) {
        return CollectionUtils.flattenCollections(Object.class, things);
    }

    public static <T> List<T> flattenCollections(Class<T> type, Object ... things) {
        if (things == null) {
            return Collections.singletonList(null);
        }
        if (things.length == 0) {
            return Collections.emptyList();
        }
        if (things.length == 1) {
            Object thing = things[0];
            if (thing == null) {
                return Collections.singletonList(null);
            }
            if (thing.getClass().isArray()) {
                Object[] thingArray = (Object[])thing;
                ArrayList<T> list = new ArrayList<T>(thingArray.length);
                for (Object thingThing : thingArray) {
                    list.addAll(CollectionUtils.flattenCollections(type, thingThing));
                }
                return list;
            }
            if (thing instanceof Collection) {
                Collection collection = (Collection)thing;
                ArrayList<T> list = new ArrayList<T>();
                for (Object element : collection) {
                    list.addAll(CollectionUtils.flattenCollections(type, element));
                }
                return list;
            }
            return Collections.singletonList(type.cast(thing));
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Object thing : things) {
            list.addAll(CollectionUtils.flattenCollections(type, thing));
        }
        return list;
    }

    public static <T> Set<T> toSet(Iterable<? extends T> things) {
        if (things == null) {
            return new HashSet(0);
        }
        if (things instanceof Set) {
            Set castThings = (Set)things;
            return castThings;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T thing : things) {
            set.add(thing);
        }
        return set;
    }

    public static <K, V> void collectMap(Map<K, V> destination, Iterable<? extends V> items, Transformer<? extends K, ? super V> keyGenerator) {
        for (V item : items) {
            destination.put(keyGenerator.transform(item), item);
        }
    }

    public static <K, V> Map<K, V> collectMap(Iterable<? extends V> items, Transformer<? extends K, ? super V> keyGenerator) {
        LinkedHashMap map = new LinkedHashMap();
        CollectionUtils.collectMap(map, items, keyGenerator);
        return map;
    }

    public static <T> SetDiff<T> diffSetsBy(Set<? extends T> left, Set<? extends T> right, Transformer<?, T> compareBy) {
        if (left == null) {
            throw new NullPointerException("'left' set is null");
        }
        if (right == null) {
            throw new NullPointerException("'right' set is null");
        }
        SetDiff setDiff = new SetDiff();
        Map<?, T> indexedLeft = CollectionUtils.collectMap(left, compareBy);
        Map<?, T> indexedRight = CollectionUtils.collectMap(right, compareBy);
        for (Map.Entry<?, T> leftEntry : indexedLeft.entrySet()) {
            T rightValue = indexedRight.remove(leftEntry.getKey());
            if (rightValue == null) {
                setDiff.leftOnly.add(leftEntry.getValue());
                continue;
            }
            Pair pair = Pair.of(leftEntry.getValue(), rightValue);
            setDiff.common.add(pair);
        }
        for (Map.Entry<?, ? extends T> rightValue : indexedRight.values()) {
            setDiff.rightOnly.add(rightValue);
        }
        return setDiff;
    }

    public static class SetDiff<T> {
        public Set<T> leftOnly = new HashSet<T>();
        public Set<Pair<T, T>> common = new HashSet<Pair<T, T>>();
        public Set<T> rightOnly = new HashSet<T>();
    }
}

