/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.run;

import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.fingerprint.classpath.ClasspathFingerprinter;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.extensions.internal.PlayMajorVersion;
import org.gradle.playframework.tools.internal.run.PlayApplicationRunner;
import org.gradle.playframework.tools.internal.run.PlayRunAdapterV23X;
import org.gradle.playframework.tools.internal.run.PlayRunAdapterV24X;
import org.gradle.playframework.tools.internal.run.PlayRunAdapterV25X;
import org.gradle.playframework.tools.internal.run.PlayRunAdapterV26X;
import org.gradle.playframework.tools.internal.run.PlayRunAdapterV27X;
import org.gradle.playframework.tools.internal.run.VersionedPlayRunAdapter;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class PlayApplicationRunnerFactory {
    public static PlayApplicationRunner create(PlayPlatform playPlatform, WorkerProcessFactory workerFactory, ClasspathFingerprinter fingerprinter, FileCollectionFactory fileCollectionFactory) {
        return new PlayApplicationRunner(workerFactory, PlayApplicationRunnerFactory.createPlayRunAdapter(playPlatform), fingerprinter, fileCollectionFactory);
    }

    public static VersionedPlayRunAdapter createPlayRunAdapter(PlayPlatform playPlatform) {
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_3_X: {
                return new PlayRunAdapterV23X();
            }
            case PLAY_2_4_X: {
                return new PlayRunAdapterV24X();
            }
            case PLAY_2_5_X: {
                return new PlayRunAdapterV25X();
            }
            case PLAY_2_6_X: {
                return new PlayRunAdapterV26X();
            }
        }
        return new PlayRunAdapterV27X();
    }
}

