/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.playframework.tasks.internal.JavaScriptMinifyParameters;
import org.gradle.playframework.tasks.internal.JavaScriptMinifyRunnable;
import org.gradle.playframework.tasks.internal.JavaScriptMinifyWorkAction;
import org.gradle.playframework.tools.internal.javascript.DefaultJavaScriptCompileSpec;
import org.gradle.playframework.tools.internal.javascript.SimpleStaleClassCleaner;
import org.gradle.playframework.tools.internal.javascript.StaleClassCleaner;
import org.gradle.util.GradleVersion;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public class JavaScriptMinify
extends SourceTask {
    private final WorkerExecutor workerExecutor;
    private final Property<Directory> destinationDir;
    private final ConfigurableFileCollection compilerClasspath;

    @Inject
    public JavaScriptMinify(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        this.include(new String[]{"**/*.js"});
        this.destinationDir = this.getProject().getObjects().directoryProperty();
        this.compilerClasspath = this.getProject().files(new Object[0]);
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @OutputDirectory
    public Property<Directory> getDestinationDir() {
        return this.destinationDir;
    }

    @Classpath
    public ConfigurableFileCollection getCompilerClasspath() {
        return this.compilerClasspath;
    }

    @TaskAction
    void compileJavaScriptSources() {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getOutputs());
        ((StaleClassCleaner)cleaner).addDirToClean(((Directory)this.destinationDir.get()).getAsFile());
        ((StaleClassCleaner)cleaner).execute();
        MinifyFileVisitor visitor = new MinifyFileVisitor();
        this.getSource().visit((FileVisitor)visitor);
        final DefaultJavaScriptCompileSpec spec = new DefaultJavaScriptCompileSpec(visitor.relativeFiles, ((Directory)this.destinationDir.get()).getAsFile());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.6")) < 0) {
            this.workerExecutor.submit(JavaScriptMinifyRunnable.class, workerConfiguration -> {
                workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
                workerConfiguration.forkOptions(options -> options.jvmArgs(new Object[]{"-XX:MaxMetaspaceSize=256m"}));
                workerConfiguration.params(new Object[]{spec});
                workerConfiguration.classpath((Iterable)this.compilerClasspath);
                workerConfiguration.setDisplayName("Minifying JavaScript source files");
            });
        } else {
            WorkQueue workQueue = this.workerExecutor.processIsolation((Action)new Action<ProcessWorkerSpec>(){

                public void execute(ProcessWorkerSpec workerSpec) {
                    workerSpec.forkOptions(options -> options.jvmArgs(new Object[]{"-XX:MaxMetaspaceSize=256m"}));
                    workerSpec.getClasspath().from(new Object[]{JavaScriptMinify.this.compilerClasspath});
                }
            });
            workQueue.submit(JavaScriptMinifyWorkAction.class, (Action)new Action<JavaScriptMinifyParameters>(){

                public void execute(JavaScriptMinifyParameters parameters) {
                    parameters.getSpec().set((Object)spec);
                }
            });
        }
    }

    class MinifyFileVisitor
    implements FileVisitor {
        List<RelativeFile> relativeFiles = new ArrayList<RelativeFile>();

        MinifyFileVisitor() {
        }

        public void visitDir(FileVisitDetails dirDetails) {
            new File(((Directory)JavaScriptMinify.this.destinationDir.get()).getAsFile(), dirDetails.getRelativePath().getPathString()).mkdirs();
        }

        public void visitFile(FileVisitDetails fileDetails) {
            File outputFileDir = new File(((Directory)JavaScriptMinify.this.destinationDir.get()).getAsFile(), fileDetails.getRelativePath().getParent().getPathString());
            FileOperations fileOperations = ((ProjectInternal)JavaScriptMinify.this.getProject()).getFileOperations();
            fileOperations.copy(copySpec -> copySpec.from(new Object[]{fileDetails.getFile()}).into((Object)outputFileDir));
            this.relativeFiles.add(new RelativeFile(fileDetails.getFile(), fileDetails.getRelativePath()));
        }
    }
}

