/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.extensions;

import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.playframework.util.VersionNumber;

public class PlayPlatform {
    public static final String DEFAULT_PLAY_VERSION = "2.6.25";
    private final Property<String> playVersion;
    private final Property<String> scalaVersion;
    private final Property<JavaVersion> javaVersion;

    @Inject
    public PlayPlatform(ObjectFactory objectFactory) {
        this.playVersion = objectFactory.property(String.class);
        this.scalaVersion = objectFactory.property(String.class);
        this.javaVersion = objectFactory.property(JavaVersion.class);
    }

    @Input
    public Property<String> getPlayVersion() {
        return this.playVersion;
    }

    @Input
    public Property<String> getScalaVersion() {
        return this.scalaVersion;
    }

    @Internal
    public Provider<String> getScalaCompatibilityVersion() {
        return this.scalaVersion.map(s -> {
            VersionNumber versionNumber = VersionNumber.parse(s);
            return versionNumber.getMajor() + "." + versionNumber.getMinor();
        });
    }

    @Input
    public Property<JavaVersion> getJavaVersion() {
        return this.javaVersion;
    }

    public Provider<String> getDependencyNotation(String playModule) {
        return this.getScalaCompatibilityVersion().map(s -> "com.typesafe.play:" + playModule + "_" + s + ":" + (String)this.playVersion.get());
    }
}

