/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.run;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.playframework.tools.internal.run.PlayRunSpec;

public class DefaultPlayRunSpec
implements PlayRunSpec,
Serializable {
    private final Iterable<File> classpath;
    private final Iterable<File> changingClasspath;
    private final File applicationJar;
    private final File assetsJar;
    private final Iterable<File> assetsDirs;
    private final File projectPath;
    private BaseForkOptions forkOptions;
    private int httpPort;

    public DefaultPlayRunSpec(Iterable<File> classpath, Iterable<File> changingClasspath, File applicationJar, File assetsJar, Iterable<File> assetsDirs, File projectPath, BaseForkOptions forkOptions, int httpPort) {
        this.classpath = this.toLinkedHashSet(classpath);
        this.changingClasspath = changingClasspath != null ? this.toLinkedHashSet(changingClasspath) : Collections.emptySet();
        this.applicationJar = applicationJar;
        this.assetsJar = assetsJar;
        this.assetsDirs = this.toLinkedHashSet(assetsDirs);
        this.projectPath = projectPath;
        this.forkOptions = forkOptions;
        this.httpPort = httpPort;
    }

    private LinkedHashSet<File> toLinkedHashSet(Iterable<File> classpath) {
        ArrayList target = new ArrayList();
        classpath.forEach(target::add);
        return new LinkedHashSet<File>(target);
    }

    @Override
    public BaseForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Override
    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    @Override
    public Iterable<File> getChangingClasspath() {
        return this.changingClasspath;
    }

    @Override
    public File getProjectPath() {
        return this.projectPath;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    public File getApplicationJar() {
        return this.applicationJar;
    }

    @Override
    public File getAssetsJar() {
        return this.assetsJar;
    }

    @Override
    public Iterable<File> getAssetsDirs() {
        return this.assetsDirs;
    }
}

