/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.tools.internal.routes;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.Cast;
import org.gradle.playframework.tools.internal.reflection.DirectInstantiator;
import org.gradle.playframework.tools.internal.reflection.JavaMethod;
import org.gradle.playframework.tools.internal.reflection.JavaReflectionUtil;
import org.gradle.playframework.tools.internal.routes.DefaultVersionedRoutesCompilerAdapter;
import org.gradle.playframework.tools.internal.scala.ScalaListBuffer;
import org.gradle.playframework.tools.internal.scala.ScalaMethod;
import org.gradle.playframework.tools.internal.scala.ScalaObject;
import org.gradle.playframework.tools.internal.scala.ScalaReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesCompilerAdapterV24X
extends DefaultVersionedRoutesCompilerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutesCompilerAdapterV24X.class);
    protected static final String PLAY_ROUTES_COMPILER_STATIC_ROUTES_GENERATOR = "play.routes.compiler.StaticRoutesGenerator";
    protected static final String PLAY_ROUTES_COMPILER_INJECTED_ROUTES_GENERATOR = "play.routes.compiler.InjectedRoutesGenerator";
    private final List<String> defaultScalaImports = new ArrayList<String>(Arrays.asList("controllers.Assets.Asset"));
    private final List<String> defaultJavaImports = new ArrayList<String>(Arrays.asList("controllers.Assets.Asset", "play.libs.F"));

    public RoutesCompilerAdapterV24X(String playVersion, String scalaVersion) {
        super(playVersion, scalaVersion);
    }

    @Override
    public ScalaMethod getCompileMethod(ClassLoader cl) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(cl, "play.routes.compiler.RoutesCompiler", "compile", cl.loadClass("play.routes.compiler.RoutesCompiler$RoutesCompilerTask"), cl.loadClass("play.routes.compiler.RoutesGenerator"), File.class);
    }

    @Override
    public Object[] createCompileParameters(ClassLoader cl, File file, File destinationDir, boolean javaProject, boolean namespaceReverseRouter, boolean generateReverseRoutes, boolean injectedRoutesGenerator, Collection<String> additionalImports) throws ClassNotFoundException {
        List<String> defaultImports = this.getDefaultImports(javaProject);
        defaultImports.addAll(additionalImports);
        Object routesCompilerTask = DirectInstantiator.instantiate(cl.loadClass("play.routes.compiler.RoutesCompiler$RoutesCompilerTask"), file, ScalaListBuffer.fromList(cl, defaultImports), this.isGenerateForwardsRouter(), generateReverseRoutes, namespaceReverseRouter);
        String routeGenerator = injectedRoutesGenerator ? PLAY_ROUTES_COMPILER_INJECTED_ROUTES_GENERATOR : PLAY_ROUTES_COMPILER_STATIC_ROUTES_GENERATOR;
        return new Object[]{routesCompilerTask, new ScalaObject(cl, routeGenerator).getInstance(), destinationDir};
    }

    protected List<String> getDefaultImports(boolean javaProject) {
        return javaProject ? this.defaultJavaImports : this.defaultScalaImports;
    }

    protected boolean isGenerateForwardsRouter() {
        return true;
    }

    @Override
    public Boolean interpretResult(Object result) throws ClassNotFoundException {
        JavaMethod<Object, Boolean> isRight = JavaReflectionUtil.method(result, Boolean.class, "isRight", new Class[0]);
        Boolean successful = (Boolean)Cast.cast(Boolean.class, (Object)isRight.invoke(result, new Object[0]));
        if (successful.booleanValue()) {
            JavaMethod<Object, Object> right = JavaReflectionUtil.method(result, Object.class, "right", new Class[0]);
            Object rightResult = right.invoke(result, new Object[0]);
            JavaMethod<Object, Object> get = JavaReflectionUtil.method(rightResult, Object.class, "get", new Class[0]);
            Object generatedFiles = get.invoke(rightResult, new Object[0]);
            JavaMethod<Object, Object> isEmpty = JavaReflectionUtil.method(generatedFiles, Object.class, "isEmpty", new Class[0]);
            Object empty = isEmpty.invoke(generatedFiles, new Object[0]);
            JavaMethod<Object, Boolean> booleanValue = JavaReflectionUtil.method(empty, Boolean.class, "booleanValue", new Class[0]);
            return booleanValue.invoke(empty, new Object[0]);
        }
        JavaMethod<Object, Object> left = JavaReflectionUtil.method(result, Object.class, "left", new Class[0]);
        Object leftResult = left.invoke(result, new Object[0]);
        JavaMethod<Object, Object> get = JavaReflectionUtil.method(leftResult, Object.class, "get", new Class[0]);
        Object errorSeq = get.invoke(leftResult, new Object[0]);
        ClassLoader resultCl = result.getClass().getClassLoader();
        ScalaMethod seqAsJavaList = ScalaReflectionUtil.scalaMethod(resultCl, this.getScalaToJavaConverterClassName(), "seqAsJavaList", resultCl.loadClass("scala.collection.Seq"));
        List errors = (List)Cast.uncheckedCast((Object)seqAsJavaList.invoke(errorSeq));
        RoutesCompilationErrorAdapter errorAdapter = new RoutesCompilationErrorAdapter(resultCl.loadClass("play.routes.compiler.RoutesCompilationError"), resultCl.loadClass("scala.Option"));
        for (Object error : errors) {
            RoutesCompilationError adaptedError = errorAdapter.adapt(error);
            String message = adaptedError.toString();
            LOGGER.error(message);
        }
        throw new RuntimeException("route compilation failed with errors");
    }

    protected String getScalaToJavaConverterClassName() {
        return "scala.collection.JavaConversions";
    }

    private static class RoutesCompilationError {
        private final File source;
        private final String message;
        private final int line;
        private final int col;

        private RoutesCompilationError(File source, String message, int line, int col) {
            this.source = source;
            this.message = message;
            this.line = line;
            this.col = col;
        }

        public String toString() {
            if (this.line > 0 && this.col > 0) {
                return this.source.getAbsolutePath() + ":" + this.line + ":" + this.col + " " + this.message;
            }
            return this.source.getAbsolutePath() + " " + this.message;
        }
    }

    private static class RoutesCompilationErrorAdapter {
        private final JavaMethod<Object, File> sourceMethod;
        private final JavaMethod<Object, String> messageMethod;
        private final JavaMethod<Object, Object> lineMethod;
        private final JavaMethod<Object, Object> columnMethod;
        private final JavaMethod<Object, Object> getMethod;

        private RoutesCompilationErrorAdapter(Class<?> routesCompilationError, Class<?> option) {
            this.sourceMethod = (JavaMethod)Cast.uncheckedCast(JavaReflectionUtil.method(routesCompilationError, File.class, "source", new Class[0]));
            this.messageMethod = (JavaMethod)Cast.uncheckedCast(JavaReflectionUtil.method(routesCompilationError, String.class, "message", new Class[0]));
            this.lineMethod = (JavaMethod)Cast.uncheckedCast(JavaReflectionUtil.method(routesCompilationError, Object.class, "line", new Class[0]));
            this.columnMethod = (JavaMethod)Cast.uncheckedCast(JavaReflectionUtil.method(routesCompilationError, Object.class, "column", new Class[0]));
            this.getMethod = (JavaMethod)Cast.uncheckedCast(JavaReflectionUtil.method(option, Object.class, "get", new Class[0]));
        }

        RoutesCompilationError adapt(Object error) {
            return new RoutesCompilationError(this.sourceMethod.invoke(error, new Object[0]), this.messageMethod.invoke(error, new Object[0]), this.toInt(this.lineMethod.invoke(error, new Object[0])), this.toInt(this.columnMethod.invoke(error, new Object[0])));
        }

        Integer toInt(Object optionInt) {
            try {
                return (Integer)Cast.uncheckedCast((Object)this.getMethod.invoke(optionInt, new Object[0]));
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

