/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.distribution.plugins.DistributionPlugin;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.playframework.extensions.PlayExtension;
import org.gradle.playframework.extensions.PlayPlatform;
import org.gradle.playframework.extensions.internal.PlayMajorVersion;
import org.gradle.playframework.plugins.PlayApplicationPlugin;
import org.gradle.util.GradleVersion;

public class PlayDistributionPlugin
implements Plugin<Project> {
    public static final String DISTRIBUTION_GROUP = "distribution";
    public static final String STAGE_LIFECYCLE_TASK_NAME = "stage";
    public static final String DIST_LIFECYCLE_TASK_NAME = "dist";

    public void apply(Project project) {
        project.getPluginManager().apply(PlayApplicationPlugin.class);
        project.getPluginManager().apply(DistributionPlugin.class);
        TaskProvider<Task> stageLifecycleTask = this.createStageLifecycleTask(project);
        TaskProvider<Task> distLifecycleTask = this.createDistLifecycleTasks(project);
        DistributionContainer distributionContainer = (DistributionContainer)project.getExtensions().getByName("distributions");
        distributionContainer.all(distribution -> {
            this.createDistributionContentTasks(project, (Distribution)distribution);
            this.createDistributionZipTasks(project, (Distribution)distribution, stageLifecycleTask, distLifecycleTask);
        });
    }

    private TaskProvider<Task> createStageLifecycleTask(Project project) {
        return project.getTasks().register(STAGE_LIFECYCLE_TASK_NAME, task -> {
            task.setDescription("Stages all Play distributions.");
            task.setGroup(DISTRIBUTION_GROUP);
        });
    }

    private TaskProvider<Task> createDistLifecycleTasks(Project project) {
        return project.getTasks().register(DIST_LIFECYCLE_TASK_NAME, task -> {
            task.setDescription("Assembles all Play distributions.");
            task.setGroup(DISTRIBUTION_GROUP);
        });
    }

    private void createDistributionContentTasks(Project project, Distribution distribution) {
        PlayExtension playExtension = (PlayExtension)project.getExtensions().getByName("play");
        TaskProvider mainJarTask = project.getTasks().named("jar", Jar.class);
        TaskProvider assetsJarTask = project.getTasks().named("createPlayAssetsJar", Jar.class);
        String capitalizedDistName = this.capitalizeDistributionName(distribution.getName());
        String jarTaskName = "create" + capitalizedDistName + "DistributionJar";
        TaskProvider distributionJarTask = project.getTasks().register(jarTaskName, Jar.class, jar -> {
            jar.setDescription("Assembles an application jar suitable for deployment.");
            jar.dependsOn(new Object[]{mainJarTask, assetsJarTask});
            jar.from(new Object[]{project.zipTree((Object)mainJarTask.flatMap(AbstractArchiveTask::getArchiveFile))});
            jar.getDestinationDirectory().convention(project.getLayout().getBuildDirectory().dir("distributionJars/" + distribution.getName()));
            jar.getArchiveBaseName().convention(mainJarTask.flatMap(AbstractArchiveTask::getArchiveBaseName));
            HashMap<String, PlayManifestClasspath> classpath = new HashMap<String, PlayManifestClasspath>();
            classpath.put("Class-Path", new PlayManifestClasspath(project.getConfigurations().getByName("runtimeClasspath"), ((Jar)assetsJarTask.get()).getArchivePath()));
            jar.getManifest().attributes(classpath);
        });
        File scriptsDir = new File(project.getBuildDir(), "scripts");
        String createStartScriptsTaskName = "create" + capitalizedDistName + "StartScripts";
        TaskProvider createStartScriptsTask = project.getTasks().register(createStartScriptsTaskName, CreateStartScripts.class, createStartScripts -> {
            createStartScripts.setDescription("Creates OS specific scripts to run the distribution.");
            createStartScripts.setClasspath(((Jar)distributionJarTask.get()).getOutputs().getFiles());
            createStartScripts.setMainClassName(this.getMainClass(playExtension.getPlatform()));
            createStartScripts.setApplicationName(distribution.getName());
            createStartScripts.setOutputDir(scriptsDir);
        });
        CopySpec distSpec = distribution.getContents();
        distSpec.into((Object)"lib", copySpec -> {
            copySpec.from(new Object[]{distributionJarTask});
            copySpec.from(new Object[]{assetsJarTask.flatMap(AbstractArchiveTask::getArchiveFile)});
            copySpec.from(new Object[]{project.getConfigurations().getByName("runtimeClasspath")});
            copySpec.eachFile((Action)new PrefixArtifactFileNames(project.getConfigurations().getByName("runtimeClasspath")));
        });
        distSpec.into((Object)"bin", copySpec -> {
            copySpec.from(new Object[]{createStartScriptsTask});
            copySpec.setFileMode(Integer.valueOf(493));
        });
        distSpec.into((Object)"conf", copySpec -> copySpec.from(new Object[]{"conf"}).exclude(new String[]{"routes"}));
        distSpec.from(new Object[]{"README"});
    }

    private String getMainClass(PlayPlatform playPlatform) {
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_3_X: {
                return "play.core.server.NettyServer";
            }
        }
        return "play.core.server.ProdServerStart";
    }

    private void createDistributionZipTasks(Project project, Distribution distribution, TaskProvider<Task> stageLifecycleTask, TaskProvider<Task> distLifecycleTask) {
        String capitalizedDistName = this.capitalizeDistributionName(distribution.getName());
        String stageTaskName = STAGE_LIFECYCLE_TASK_NAME + capitalizedDistName + "Dist";
        File stageDir = new File(project.getBuildDir(), STAGE_LIFECYCLE_TASK_NAME);
        Provider<String> baseName = this.getBaseNameForDistribution(project.getProviders(), distribution);
        TaskProvider stageSyncTask = project.getTasks().register(stageTaskName, Sync.class, sync -> {
            sync.setDescription("Copies the '" + distribution.getName() + "' distribution to a staging directory.");
            sync.setDestinationDir(stageDir);
            sync.into(baseName.get(), copySpec -> copySpec.with(new CopySpec[]{distribution.getContents()}));
        });
        stageLifecycleTask.configure(task -> task.dependsOn(new Object[]{stageSyncTask}));
        String distributionZipTaskName = "create" + capitalizedDistName + "ZipDist";
        TaskProvider distZipTask = project.getTasks().register(distributionZipTaskName, Zip.class, zip -> {
            zip.setDescription("Packages the '" + distribution.getName() + "' distribution as a zip file.");
            zip.getArchiveBaseName().set(baseName);
            zip.getDestinationDirectory().convention(project.getLayout().getBuildDirectory().dir("distributions"));
            zip.from(new Object[]{stageSyncTask});
        });
        String distributionTarTaskName = "create" + capitalizedDistName + "TarDist";
        TaskProvider distTarTask = project.getTasks().register(distributionTarTaskName, Tar.class, tar -> {
            tar.setDescription("Packages the '" + distribution.getName() + "' distribution as a tar file.");
            tar.getArchiveBaseName().set(baseName);
            tar.getDestinationDirectory().convention(project.getLayout().getBuildDirectory().dir("distributions"));
            tar.from(new Object[]{stageSyncTask});
        });
        distLifecycleTask.configure(task -> {
            task.dependsOn(new Object[]{distZipTask});
            task.dependsOn(new Object[]{distTarTask});
        });
    }

    private Provider<String> getBaseNameForDistribution(ProviderFactory providers, final Distribution distribution) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.0")) < 0) {
            return providers.provider((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String baseName = (String)Distribution.class.getMethod("getBaseName", new Class[0]).invoke((Object)distribution, new Object[0]);
                    return "".equals(baseName) ? "" : distribution.getName();
                }
            });
        }
        return distribution.getDistributionBaseName().map(baseName -> baseName.isEmpty() ? "" : distribution.getName()).orElse((Object)distribution.getName());
    }

    private String capitalizeDistributionName(String distributionName) {
        return Character.toUpperCase(distributionName.charAt(0)) + distributionName.substring(1);
    }

    private static boolean hasExtension(File file, String extension) {
        return file.getPath().endsWith(extension);
    }

    static class PrefixArtifactFileNames
    implements Action<FileCopyDetails>,
    Function<File, String> {
        private final Configuration configuration;
        Map<File, String> renames;

        PrefixArtifactFileNames(Configuration configuration) {
            this.configuration = configuration;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.setName(this.apply(fileCopyDetails.getFile()));
        }

        @Override
        public String apply(File input) {
            this.calculateRenames();
            String rename = this.renames.get(input);
            if (rename != null) {
                return rename;
            }
            return input.getName();
        }

        private void calculateRenames() {
            if (this.renames == null) {
                this.renames = this.calculate();
            }
        }

        private Map<File, String> calculate() {
            HashMap<File, String> files = new HashMap<File, String>();
            for (ResolvedArtifactResult artifact : this.getResolvedArtifacts()) {
                ComponentIdentifier componentId = artifact.getId().getComponentIdentifier();
                if (componentId instanceof ProjectComponentIdentifier) {
                    ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)componentId;
                    files.put(artifact.getFile(), PrefixArtifactFileNames.renameForProject(projectComponentIdentifier, artifact.getFile()));
                    continue;
                }
                if (componentId instanceof ModuleComponentIdentifier) {
                    ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)componentId;
                    files.put(artifact.getFile(), PrefixArtifactFileNames.renameForModule(moduleComponentIdentifier, artifact.getFile()));
                    continue;
                }
                files.put(artifact.getFile(), artifact.getFile().getName());
            }
            return Collections.unmodifiableMap(files);
        }

        Set<ResolvedArtifactResult> getResolvedArtifacts() {
            ArtifactCollection artifacts = this.configuration.getIncoming().getArtifacts();
            return artifacts.getArtifacts();
        }

        static String renameForProject(ProjectComponentIdentifier id, File file) {
            String fileName = file.getName();
            if (PrefixArtifactFileNames.shouldBeRenamed(file)) {
                String projectPath = id.getProjectPath();
                projectPath = PrefixArtifactFileNames.projectPathToSafeFileName(projectPath);
                return PrefixArtifactFileNames.maybePrefix(projectPath, file);
            }
            return fileName;
        }

        static String renameForModule(ModuleComponentIdentifier id, File file) {
            if (PrefixArtifactFileNames.shouldBeRenamed(file)) {
                return PrefixArtifactFileNames.maybePrefix(id.getGroup(), file);
            }
            return file.getName();
        }

        private static String maybePrefix(String prefix, File file) {
            if (prefix == null || prefix.length() <= 0) {
                return file.getName();
            }
            return prefix + "-" + file.getName();
        }

        private static String projectPathToSafeFileName(String projectPath) {
            if (projectPath.equals(":")) {
                return null;
            }
            return projectPath.replaceAll(":", ".").substring(1);
        }

        private static boolean shouldBeRenamed(File file) {
            return PlayDistributionPlugin.hasExtension(file, ".jar");
        }
    }

    static class PlayManifestClasspath {
        final Configuration configuration;
        final File assetsJarFile;

        public PlayManifestClasspath(Configuration configuration, File assetsJarFile) {
            this.configuration = configuration;
            this.assetsJarFile = assetsJarFile;
        }

        public String toString() {
            Stream allFiles = Stream.concat(this.configuration.getFiles().stream(), Collections.singleton(this.assetsJarFile).stream());
            Stream<String> transformedFiles = allFiles.map(new PrefixArtifactFileNames(this.configuration));
            return String.join((CharSequence)" ", transformedFiles.collect(Collectors.toList()));
        }
    }
}

