/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.playframework.plugins;

import java.util.ArrayList;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.provider.Provider;
import org.gradle.playframework.extensions.PlayExtension;
import org.gradle.playframework.plugins.PlayGeneratedSourcePlugin;
import org.gradle.playframework.plugins.internal.PlayPluginHelper;
import org.gradle.playframework.sourcesets.RoutesSourceSet;
import org.gradle.playframework.sourcesets.internal.DefaultRoutesSourceSet;
import org.gradle.playframework.tasks.RoutesCompile;
import org.gradle.playframework.tools.internal.routes.RoutesCompilerFactory;

public class PlayRoutesPlugin
implements PlayGeneratedSourcePlugin {
    public static final String ROUTES_COMPILER_CONFIGURATION_NAME = "routesCompiler";
    public static final String ROUTES_COMPILE_TASK_NAME = "compilePlayRoutes";

    public void apply(Project project) {
        PlayExtension playExtension = (PlayExtension)project.getExtensions().getByName("play");
        Configuration routesCompilerConfiguration = this.createRoutesCompilerConfiguration(project);
        this.declareDefaultDependencies(project, routesCompilerConfiguration, playExtension);
        RoutesSourceSet routesSourceSet = PlayPluginHelper.createCustomSourceSet(project, DefaultRoutesSourceSet.class, "routes");
        this.createDefaultRoutesCompileTask(project, routesSourceSet.getRoutes(), routesCompilerConfiguration, playExtension, (Provider<Boolean>)playExtension.getInjectedRoutesGenerator());
    }

    private Configuration createRoutesCompilerConfiguration(Project project) {
        Configuration compilerConfiguration = (Configuration)project.getConfigurations().create(ROUTES_COMPILER_CONFIGURATION_NAME);
        compilerConfiguration.setVisible(false);
        compilerConfiguration.setTransitive(true);
        compilerConfiguration.setDescription("The routes compiler library used to generate Scala source from routes templates.");
        return compilerConfiguration;
    }

    private void declareDefaultDependencies(Project project, Configuration configuration, PlayExtension playExtension) {
        configuration.defaultDependencies(dependencies -> {
            String dependencyNotation = RoutesCompilerFactory.createAdapter(playExtension.getPlatform()).getDependencyNotation();
            dependencies.add((Object)project.getDependencies().create((Object)dependencyNotation));
        });
    }

    private void createDefaultRoutesCompileTask(Project project, SourceDirectorySet sourceDirectory, Configuration compilerConfiguration, PlayExtension playExtension, Provider<Boolean> injectedRoutesGenerator) {
        project.getTasks().register(ROUTES_COMPILE_TASK_NAME, RoutesCompile.class, routesCompile -> {
            routesCompile.setDescription("Generates routes for the '" + sourceDirectory.getDisplayName() + "' source set.");
            routesCompile.getPlatform().set(project.provider(() -> playExtension.getPlatform()));
            routesCompile.getAdditionalImports().set(new ArrayList());
            routesCompile.setSource((FileTree)sourceDirectory);
            routesCompile.getOutputDirectory().set(this.getOutputDir(project, sourceDirectory));
            routesCompile.getInjectedRoutesGenerator().set(injectedRoutesGenerator);
            routesCompile.getRoutesCompilerClasspath().setFrom((Iterable)compilerConfiguration);
        });
    }
}

