/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.internal.consumer.converters.IdeaModuleDependencyTargetNameMixin;
import org.gradle.tooling.internal.consumer.converters.IdeaProjectJavaLanguageSettingsMixin;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaModelCompatibilityMapping
implements Action<ViewBuilder<?>> {
    private final boolean versionSupportsIdeaJavaSourceSettings;
    private final boolean versionSupportsIdeaModuleTargetName;

    public IdeaModelCompatibilityMapping(VersionDetails versionDetails) {
        GradleVersion targetGradleVersion = GradleVersion.version(versionDetails.getVersion());
        this.versionSupportsIdeaJavaSourceSettings = this.supportsIdeaJavaSourceSettings(targetGradleVersion);
        this.versionSupportsIdeaModuleTargetName = this.supportsIdeaModuleTargetName(targetGradleVersion);
    }

    @Override
    public void execute(ViewBuilder<?> viewBuilder) {
        if (!this.versionSupportsIdeaJavaSourceSettings) {
            viewBuilder.mixInTo(IdeaProject.class, IdeaProjectJavaLanguageSettingsMixin.class);
        }
        if (!this.versionSupportsIdeaModuleTargetName) {
            viewBuilder.mixInTo(IdeaDependency.class, IdeaModuleDependencyTargetNameMixin.class);
        }
    }

    private boolean supportsIdeaJavaSourceSettings(GradleVersion targetGradleVersion) {
        return targetGradleVersion.getBaseVersion().compareTo(GradleVersion.version("2.11")) >= 0;
    }

    private boolean supportsIdeaModuleTargetName(GradleVersion targetGradleVersion) {
        return targetGradleVersion.getBaseVersion().compareTo(GradleVersion.version("3.1")) >= 0;
    }
}

