/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.adapter;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.tooling.internal.adapter.CollectionMapper;
import org.gradle.tooling.internal.adapter.MethodInvocation;
import org.gradle.tooling.internal.adapter.MethodInvoker;
import org.gradle.tooling.internal.adapter.NoOpMethodInvoker;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolToModelAdapter
implements Serializable {
    private static final MethodInvoker NO_OP_HANDLER = new NoOpMethodInvoker();
    private static final Action<SourceObjectMapping> NO_OP_MAPPER = new NoOpMapping();
    private static final TargetTypeProvider IDENTITY_TYPE_PROVIDER = new TargetTypeProvider(){

        @Override
        public <T> Class<? extends T> getTargetType(Class<T> initialTargetType, Object protocolObject) {
            return initialTargetType;
        }
    };
    private static final Object[] EMPTY = new Object[0];
    private static final Pattern IS_SUPPORT_METHOD = Pattern.compile("is(\\w+)Supported");
    private static final Pattern GETTER_METHOD = Pattern.compile("get(\\w+)");
    private static final Pattern IS_METHOD = Pattern.compile("is(\\w+)");
    private final TargetTypeProvider targetTypeProvider;
    private final CollectionMapper collectionMapper = new CollectionMapper();

    public ProtocolToModelAdapter() {
        this(IDENTITY_TYPE_PROVIDER);
    }

    public ProtocolToModelAdapter(TargetTypeProvider targetTypeProvider) {
        this.targetTypeProvider = targetTypeProvider;
    }

    public <T, S> T adapt(Class<T> targetType, S sourceObject) {
        return this.adapt(targetType, sourceObject, NO_OP_MAPPER);
    }

    public <T, S> T adapt(Class<T> targetType, final S sourceObject, final Class<?> mixInClass) {
        return this.adapt(targetType, sourceObject, (Action<? super SourceObjectMapping>)new Action<SourceObjectMapping>(){

            @Override
            public void execute(SourceObjectMapping mapping) {
                if (mapping.getSourceObject() == sourceObject) {
                    mapping.mixIn(mixInClass);
                }
            }
        });
    }

    public <T, S> T adapt(Class<T> targetType, S sourceObject, Action<? super SourceObjectMapping> mapper) {
        if (sourceObject == null) {
            return null;
        }
        Class<T> wrapperType = this.targetTypeProvider.getTargetType(targetType, sourceObject);
        DefaultSourceObjectMapping mapping = new DefaultSourceObjectMapping(sourceObject, targetType, wrapperType);
        mapper.execute(mapping);
        wrapperType = mapping.wrapperType.asSubclass(targetType);
        if (wrapperType.isInstance(sourceObject)) {
            return wrapperType.cast(sourceObject);
        }
        MethodInvoker overrideMethodInvoker = mapping.overrideInvoker;
        MixInMethodInvoker mixInMethodInvoker = null;
        if (mapping.mixInType != null) {
            mixInMethodInvoker = new MixInMethodInvoker(mapping.mixInType, new AdaptingMethodInvoker(mapper, new ReflectionMethodInvoker()));
            overrideMethodInvoker = mixInMethodInvoker;
        }
        Object proxy = Proxy.newProxyInstance(wrapperType.getClassLoader(), new Class[]{wrapperType}, (InvocationHandler)new InvocationHandlerImpl(sourceObject, overrideMethodInvoker, mapper));
        if (mixInMethodInvoker != null) {
            mixInMethodInvoker.setProxy(proxy);
        }
        return wrapperType.cast(proxy);
    }

    public Object unpack(Object viewObject) {
        if (!Proxy.isProxyClass(viewObject.getClass()) || !(Proxy.getInvocationHandler(viewObject) instanceof InvocationHandlerImpl)) {
            throw new IllegalArgumentException("The given object is not a view object");
        }
        InvocationHandlerImpl handler = (InvocationHandlerImpl)Proxy.getInvocationHandler(viewObject);
        return handler.delegate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MixInMethodInvoker
    implements MethodInvoker {
        private Object proxy;
        private Object instance;
        private final Class<?> mixInClass;
        private final MethodInvoker next;
        private final ThreadLocal<MethodInvocation> current = new ThreadLocal();

        public MixInMethodInvoker(Class<?> mixInClass, MethodInvoker next) {
            this.mixInClass = mixInClass;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            if (this.current.get() != null) {
                return;
            }
            if (this.instance == null) {
                this.instance = new DirectInstantiator().newInstance(this.mixInClass, this.proxy);
            }
            MethodInvocation beanInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), invocation.getParameterTypes(), this.instance, invocation.getParameters());
            this.current.set(beanInvocation);
            try {
                this.next.invoke(beanInvocation);
            }
            finally {
                this.current.set(null);
            }
            if (beanInvocation.found()) {
                invocation.setResult(beanInvocation.getResult());
            }
        }

        public void setProxy(Object proxy) {
            this.proxy = proxy;
        }

        public Object getProxy() {
            return this.proxy;
        }
    }

    private static class SupportedPropertyInvoker
    implements MethodInvoker {
        private final MethodInvoker next;

        private SupportedPropertyInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            Matcher matcher = IS_SUPPORT_METHOD.matcher(invocation.getName());
            if (!matcher.matches()) {
                this.next.invoke(invocation);
                return;
            }
            String getterName = String.format("get%s", matcher.group(1));
            MethodInvocation getterInvocation = new MethodInvocation(getterName, invocation.getReturnType(), invocation.getGenericReturnType(), new Class[0], invocation.getDelegate(), EMPTY);
            this.next.invoke(getterInvocation);
            invocation.setResult(getterInvocation.found());
        }
    }

    private static class SafeMethodInvoker
    implements MethodInvoker {
        private final MethodInvoker next;

        private SafeMethodInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            this.next.invoke(invocation);
            if (invocation.found()) {
                return;
            }
            boolean getter = GETTER_METHOD.matcher(invocation.getName()).matches();
            if (!getter || invocation.getParameterTypes().length != 1) {
                return;
            }
            MethodInvocation getterInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), new Class[0], invocation.getDelegate(), EMPTY);
            this.next.invoke(getterInvocation);
            if (getterInvocation.found() && getterInvocation.getResult() != null) {
                invocation.setResult(getterInvocation.getResult());
            } else {
                invocation.setResult(invocation.getParameters()[0]);
            }
        }
    }

    private static class PropertyCachingMethodInvoker
    implements MethodInvoker {
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private final Set<String> unknown = new HashSet<String>();
        private final MethodInvoker next;

        private PropertyCachingMethodInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation method) throws Throwable {
            if ((GETTER_METHOD.matcher(method.getName()).matches() || IS_METHOD.matcher(method.getName()).matches()) && method.getParameterTypes().length == 0) {
                if (this.properties.containsKey(method.getName())) {
                    method.setResult(this.properties.get(method.getName()));
                    return;
                }
                if (this.unknown.contains(method.getName())) {
                    return;
                }
                this.next.invoke(method);
                if (!method.found()) {
                    this.unknown.add(method.getName());
                    return;
                }
                Object value = method.getResult();
                this.properties.put(method.getName(), value);
                return;
            }
            this.next.invoke(method);
        }
    }

    private class ReflectionMethodInvoker
    implements MethodInvoker {
        private ReflectionMethodInvoker() {
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            Object returnValue;
            Method targetMethod = this.locateMethod(invocation);
            if (targetMethod == null) {
                return;
            }
            try {
                returnValue = targetMethod.invoke(invocation.getDelegate(), invocation.getParameters());
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            invocation.setResult(returnValue);
        }

        private Method locateMethod(MethodInvocation invocation) {
            Method match;
            Class<?> sourceClass = invocation.getDelegate().getClass();
            try {
                match = sourceClass.getMethod(invocation.getName(), invocation.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            LinkedList queue = new LinkedList();
            queue.add(sourceClass);
            while (!queue.isEmpty()) {
                Class c = (Class)queue.removeFirst();
                try {
                    match = c.getMethod(invocation.getName(), invocation.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                for (Class<?> interfaceType : c.getInterfaces()) {
                    queue.addFirst(interfaceType);
                }
                if (c.getSuperclass() == null) continue;
                queue.addFirst(c.getSuperclass());
            }
            match.setAccessible(true);
            return match;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdaptingMethodInvoker
    implements MethodInvoker {
        private final Action<? super SourceObjectMapping> mapping;
        private final MethodInvoker next;

        private AdaptingMethodInvoker(Action<? super SourceObjectMapping> mapping, MethodInvoker next) {
            this.mapping = mapping;
            this.next = next;
        }

        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            this.next.invoke(invocation);
            if (invocation.found() && invocation.getResult() != null) {
                invocation.setResult(this.convert(invocation.getResult(), invocation.getGenericReturnType()));
            }
        }

        private Object convert(Object value, Type targetType) {
            ParameterizedType parameterizedTargetType;
            if (targetType instanceof ParameterizedType && (parameterizedTargetType = (ParameterizedType)targetType).getRawType() instanceof Class) {
                Class rawClass = (Class)parameterizedTargetType.getRawType();
                if (Iterable.class.isAssignableFrom(rawClass)) {
                    Type targetElementType = this.getElementType(parameterizedTargetType, 0);
                    Collection<Object> convertedElements = ProtocolToModelAdapter.this.collectionMapper.createEmptyCollection(rawClass);
                    for (Object element : (Iterable)value) {
                        convertedElements.add(this.convert(element, targetElementType));
                    }
                    if (rawClass.equals(DomainObjectSet.class)) {
                        return new ImmutableDomainObjectSet<Object>(convertedElements);
                    }
                    return convertedElements;
                }
                if (Map.class.isAssignableFrom(rawClass)) {
                    Type targetKeyType = this.getElementType(parameterizedTargetType, 0);
                    Type targetValueType = this.getElementType(parameterizedTargetType, 1);
                    Map<Object, Object> convertedElements = ProtocolToModelAdapter.this.collectionMapper.createEmptyMap(rawClass);
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        convertedElements.put(this.convert(entry.getKey(), targetKeyType), this.convert(entry.getValue(), targetValueType));
                    }
                    return convertedElements;
                }
            }
            if (targetType instanceof Class) {
                if (((Class)targetType).isPrimitive()) {
                    return value;
                }
                return ProtocolToModelAdapter.this.adapt((Class)targetType, value, this.mapping);
            }
            throw new UnsupportedOperationException(String.format("Cannot convert object of %s to %s.", value.getClass(), targetType));
        }

        private Type getElementType(ParameterizedType type, int index) {
            Type elementType = type.getActualTypeArguments()[index];
            if (elementType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)elementType;
                return wildcardType.getUpperBounds()[0];
            }
            return elementType;
        }
    }

    private static class ChainedMethodInvoker
    implements MethodInvoker {
        private final MethodInvoker[] invokers;

        private ChainedMethodInvoker(MethodInvoker ... invokers) {
            this.invokers = invokers;
        }

        public void invoke(MethodInvocation method) throws Throwable {
            for (int i = 0; !method.found() && i < this.invokers.length; ++i) {
                MethodInvoker invoker = this.invokers[i];
                invoker.invoke(method);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvocationHandlerImpl
    implements InvocationHandler,
    Serializable {
        private final Object delegate;
        private final MethodInvoker overrideMethodInvoker;
        private final Action<? super SourceObjectMapping> mapper;
        private transient Method equalsMethod;
        private transient Method hashCodeMethod;
        private transient MethodInvoker invoker;

        public InvocationHandlerImpl(Object delegate, MethodInvoker overrideMethodInvoker, Action<? super SourceObjectMapping> mapper) {
            this.delegate = delegate;
            this.overrideMethodInvoker = overrideMethodInvoker;
            this.mapper = mapper;
            this.setup();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.setup();
        }

        private void setup() {
            this.invoker = new SupportedPropertyInvoker(new SafeMethodInvoker(new PropertyCachingMethodInvoker(new AdaptingMethodInvoker(this.mapper, new ChainedMethodInvoker(new MethodInvoker[]{this.overrideMethodInvoker, new ReflectionMethodInvoker()})))));
            try {
                this.equalsMethod = Object.class.getMethod("equals", Object.class);
                this.hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            InvocationHandlerImpl other = (InvocationHandlerImpl)o;
            return this.delegate.equals(other.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public Object invoke(Object target, Method method, Object[] params) throws Throwable {
            if (method.equals(this.equalsMethod)) {
                Object param = params[0];
                if (param == null || !Proxy.isProxyClass(param.getClass())) {
                    return false;
                }
                InvocationHandler other = Proxy.getInvocationHandler(param);
                return this.equals(other);
            }
            if (method.equals(this.hashCodeMethod)) {
                return this.hashCode();
            }
            MethodInvocation invocation = new MethodInvocation(method.getName(), method.getReturnType(), method.getGenericReturnType(), method.getParameterTypes(), this.delegate, params);
            this.invoker.invoke(invocation);
            if (!invocation.found()) {
                String methodName = method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()";
                throw Exceptions.unsupportedMethod(methodName);
            }
            return invocation.getResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoOpMapping
    implements Action<SourceObjectMapping>,
    Serializable {
        private NoOpMapping() {
        }

        @Override
        public void execute(SourceObjectMapping mapping) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSourceObjectMapping
    implements SourceObjectMapping {
        private final Object protocolObject;
        private final Class<?> targetType;
        private Class<?> wrapperType;
        private Class<?> mixInType;
        private MethodInvoker overrideInvoker = ProtocolToModelAdapter.access$700();

        public DefaultSourceObjectMapping(Object protocolObject, Class<?> targetType, Class<?> wrapperType) {
            this.protocolObject = protocolObject;
            this.targetType = targetType;
            this.wrapperType = wrapperType;
        }

        @Override
        public Object getSourceObject() {
            return this.protocolObject;
        }

        @Override
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Override
        public void mapToType(Class<?> type) {
            if (!this.targetType.isAssignableFrom(type)) {
                throw new IllegalArgumentException(String.format("requested wrapper type '%s' is not assignable to target type '%s'.", type.getSimpleName(), this.targetType.getSimpleName()));
            }
            this.wrapperType = type;
        }

        @Override
        public void mixIn(Class<?> mixInBeanType) {
            if (this.mixInType != null) {
                throw new UnsupportedOperationException("Mixing in multiple beans is currently not supported.");
            }
            this.mixInType = mixInBeanType;
        }

        @Override
        public void mixIn(MethodInvoker invoker) {
            if (this.overrideInvoker != NO_OP_HANDLER) {
                throw new UnsupportedOperationException("Mixing in multiple invokers is currently not supported.");
            }
            this.overrideInvoker = invoker;
        }
    }
}

