/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.consumer.connection.AbstractModelProducer;
import org.gradle.tooling.internal.consumer.converters.TaskPropertyHandlerFactory;
import org.gradle.tooling.internal.consumer.parameters.BuildCancellationTokenAdapter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancellableModelBuilderBackedModelProducer
extends AbstractModelProducer {
    private final InternalCancellableConnection builder;
    private final Action<SourceObjectMapping> mapper;

    public CancellableModelBuilderBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, InternalCancellableConnection builder) {
        super(adapter, versionDetails, modelMapping);
        this.builder = builder;
        this.mapper = new TaskPropertyHandlerFactory().forVersion(versionDetails);
    }

    @Override
    public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
        BuildResult<?> result;
        if (!this.versionDetails.maySupportModel(type)) {
            throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
        }
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(type);
        try {
            result = this.builder.getModel(modelIdentifier, new BuildCancellationTokenAdapter(operationParameters.getCancellationToken()), operationParameters);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(type, e);
        }
        return this.adapter.adapt(type, result.getModel(), this.mapper);
    }
}

