/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.loader;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public class SynchronizedToolingImplementationLoader
implements ToolingImplementationLoader {
    Lock lock = new ReentrantLock();
    private final ToolingImplementationLoader delegate;

    public SynchronizedToolingImplementationLoader(ToolingImplementationLoader delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerConnection create(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, ConnectionParameters connectionParameters) {
        if (this.lock.tryLock()) {
            try {
                ConsumerConnection consumerConnection = this.delegate.create(distribution, progressLoggerFactory, connectionParameters);
                return consumerConnection;
            }
            finally {
                this.lock.unlock();
            }
        }
        ProgressLogger logger = progressLoggerFactory.newOperation(SynchronizedToolingImplementationLoader.class);
        logger.setDescription("Wait for the other thread to finish acquiring the distribution");
        logger.started();
        this.lock.lock();
        try {
            ConsumerConnection consumerConnection = this.delegate.create(distribution, progressLoggerFactory, connectionParameters);
            return consumerConnection;
        }
        finally {
            this.lock.unlock();
            logger.completed();
        }
    }
}

