/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.provider.model.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class DefaultToolingModelBuilderRegistry
implements ToolingModelBuilderRegistry {
    private final List<ToolingModelBuilder> builders = new ArrayList<ToolingModelBuilder>();

    public DefaultToolingModelBuilderRegistry() {
        this.register(new VoidToolingModelBuilder());
    }

    public void register(ToolingModelBuilder builder) {
        this.builders.add(builder);
    }

    public ToolingModelBuilder getBuilder(String modelName) throws UnsupportedOperationException {
        ToolingModelBuilder match = null;
        for (ToolingModelBuilder builder : this.builders) {
            if (!builder.canBuild(modelName)) continue;
            if (match != null) {
                throw new UnsupportedOperationException(String.format("Multiple builders are available to build a model of type '%s'.", modelName));
            }
            match = builder;
        }
        if (match != null) {
            return match;
        }
        throw new UnsupportedOperationException(String.format("No builders are available to build a model of type '%s'.", modelName));
    }

    private static class VoidToolingModelBuilder
    implements ToolingModelBuilder {
        private VoidToolingModelBuilder() {
        }

        public boolean canBuild(String modelName) {
            return modelName.equals(Void.class.getName());
        }

        public Object buildAll(String modelName, Project project) {
            return null;
        }
    }
}

