/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.gradle.tooling.internal.protocol.InternalGradleProject;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleProject
implements InternalGradleProject,
GradleProject,
Serializable {
    private String name;
    private String description;
    private String path;
    private GradleProject parent;
    private List<? extends GradleProject> children = new LinkedList<GradleProject>();
    private List<GradleTask> tasks = new LinkedList<GradleTask>();

    public DefaultGradleProject() {
    }

    public DefaultGradleProject(String path) {
        this.path = path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DefaultGradleProject setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public DefaultGradleProject setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public GradleProject getParent() {
        return this.parent;
    }

    public DefaultGradleProject setParent(GradleProject parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public DomainObjectSet<? extends GradleProject> getChildren() {
        return new ImmutableDomainObjectSet<GradleProject>(this.children);
    }

    public DefaultGradleProject setChildren(List<? extends GradleProject> children) {
        this.children = children;
        return this;
    }

    public DomainObjectSet<GradleTask> getTasks() {
        return new ImmutableDomainObjectSet<GradleTask>(this.tasks);
    }

    public DefaultGradleProject setTasks(List<GradleTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public DefaultGradleProject setPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public File getProjectDirectory() {
        throw new RuntimeException("ProjectVersion3 methods are deprecated.");
    }

    @Override
    public GradleProject findByPath(String path) {
        if (path.equals(this.path)) {
            return this;
        }
        for (GradleProject gradleProject : this.children) {
            GradleProject found = gradleProject.findByPath(path);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public String toString() {
        return "GradleProject{path='" + this.path + '\'' + "tasks='" + this.tasks + '\'' + '}';
    }
}

