/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.versioning;

import java.util.Map;
import org.gradle.jarjar.com.google.common.collect.BiMap;
import org.gradle.jarjar.com.google.common.collect.HashBiMap;
import org.gradle.tooling.internal.protocol.InternalBasicIdeaProject;
import org.gradle.tooling.internal.protocol.InternalBuildEnvironment;
import org.gradle.tooling.internal.protocol.InternalGradleProject;
import org.gradle.tooling.internal.protocol.InternalIdeaProject;
import org.gradle.tooling.internal.protocol.InternalProjectOutcomes;
import org.gradle.tooling.internal.protocol.eclipse.EclipseProjectVersion3;
import org.gradle.tooling.internal.protocol.eclipse.HierarchicalEclipseProjectVersion1;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMapping {
    private static final BiMap<Class<?>, Class<?>> MODEL_TO_PROTOCOL_MAP = HashBiMap.create();
    private static final BiMap<Class<?>, String> MODEL_NAME_MAP = HashBiMap.create();

    static void addModelToProtocolMappings(Map<Class<?>, Class<?>> map) {
        map.put(HierarchicalEclipseProject.class, HierarchicalEclipseProjectVersion1.class);
        map.put(EclipseProject.class, EclipseProjectVersion3.class);
        map.put(IdeaProject.class, InternalIdeaProject.class);
        map.put(GradleProject.class, InternalGradleProject.class);
        map.put(BasicIdeaProject.class, InternalBasicIdeaProject.class);
        map.put(BuildEnvironment.class, InternalBuildEnvironment.class);
        map.put(ProjectOutcomes.class, InternalProjectOutcomes.class);
        map.put(Void.class, Void.class);
    }

    static void addModelNameMappings(Map<Class<?>, String> map) {
        map.put(HierarchicalEclipseProject.class, "org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
        map.put(EclipseProject.class, "org.gradle.tooling.model.eclipse.EclipseProject");
        map.put(IdeaProject.class, "org.gradle.tooling.model.idea.IdeaProject");
        map.put(GradleProject.class, "org.gradle.tooling.model.GradleProject");
        map.put(BasicIdeaProject.class, "org.gradle.tooling.model.idea.BasicIdeaProject");
        map.put(BuildEnvironment.class, "org.gradle.tooling.model.build.BuildEnvironment");
        map.put(ProjectOutcomes.class, "org.gradle.tooling.model.outcomes.ProjectOutcomes");
        map.put(Void.class, Void.class.getName());
    }

    public Class<?> getProtocolType(Class<?> modelType) {
        if (MODEL_TO_PROTOCOL_MAP.containsValue(modelType)) {
            return modelType;
        }
        return (Class)MODEL_TO_PROTOCOL_MAP.get(modelType);
    }

    public String getModelName(Class<?> modelType) {
        return (String)MODEL_NAME_MAP.get(modelType);
    }

    public String getModelNameFromProtocolType(Class<?> protocolType) {
        Class modelType = (Class)MODEL_TO_PROTOCOL_MAP.inverse().get(protocolType);
        if (modelType == null) {
            return null;
        }
        return (String)MODEL_NAME_MAP.get(modelType);
    }

    public Class<?> getProtocolTypeFromModelName(String name) {
        Class modelType = (Class)MODEL_NAME_MAP.inverse().get(name);
        if (modelType == null) {
            return null;
        }
        return this.getProtocolType(modelType);
    }

    static {
        ModelMapping.addModelToProtocolMappings(MODEL_TO_PROTOCOL_MAP);
        ModelMapping.addModelNameMappings(MODEL_NAME_MAP);
    }
}

