/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractPre12ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.ProjectVersion3;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionVersion4BackedConsumerConnection
extends AbstractPre12ConsumerConnection {
    public ConnectionVersion4BackedConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, ConnectionVersion4BackedConsumerConnection.getMetaData(delegate), modelMapping, adapter);
    }

    private static VersionDetails getMetaData(ConnectionVersion4 delegate) {
        GradleVersion version = GradleVersion.version(delegate.getMetaData().getVersion());
        if (version.compareTo(GradleVersion.version("1.0-milestone-5")) < 0) {
            return new R10M3VersionDetails(delegate);
        }
        return new R10M5VersionDetails(delegate);
    }

    @Override
    protected Object doGetModel(Class<?> protocolType, ConsumerOperationParameters operationParameters) {
        return this.getDelegate().getModel(protocolType.asSubclass(ProjectVersion3.class), operationParameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R10M5VersionDetails
    extends VersionDetails {
        public R10M5VersionDetails(ConnectionVersion4 delegate) {
            super(delegate.getMetaData().getVersion());
        }

        @Override
        public boolean supportsGradleProjectModel() {
            return true;
        }

        @Override
        public boolean isModelSupported(Class<?> modelType) {
            return modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(IdeaProject.class) || modelType.equals(BasicIdeaProject.class) || modelType.equals(GradleProject.class) || modelType.equals(Void.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R10M3VersionDetails
    extends VersionDetails {
        public R10M3VersionDetails(ConnectionVersion4 delegate) {
            super(delegate.getMetaData().getVersion());
        }

        @Override
        public boolean isModelSupported(Class<?> modelType) {
            return modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(Void.class);
        }
    }
}

