/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.adapter.CompatibleIntrospector;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractConsumerConnection;
import org.gradle.tooling.internal.consumer.converters.PropertyHandlerFactory;
import org.gradle.tooling.internal.consumer.parameters.ConsumerConnectionParameters;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPre12ConsumerConnection
extends AbstractConsumerConnection {
    private final ProtocolToModelAdapter adapter;
    private final ModelMapping modelMapping;

    public AbstractPre12ConsumerConnection(ConnectionVersion4 delegate, VersionDetails providerMetaData, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, providerMetaData);
        this.modelMapping = modelMapping;
        this.adapter = adapter;
    }

    @Override
    public void configure(ConsumerConnectionParameters connectionParameters) {
        new CompatibleIntrospector(this.getDelegate()).callSafely("configureLogging", connectionParameters.getVerboseLogging());
    }

    @Override
    public <T> T run(Class<T> type, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        if (type.equals(Void.class)) {
            this.doRunBuild(operationParameters);
            return null;
        }
        Class<?> protocolType = this.modelMapping.getProtocolType(type);
        Object model = this.doGetModel(protocolType, operationParameters);
        return this.adapter.adapt(type, model, new PropertyHandlerFactory().forVersion(this.getVersionDetails()));
    }

    protected abstract Object doGetModel(Class<?> var1, ConsumerOperationParameters var2);

    protected void doRunBuild(ConsumerOperationParameters operationParameters) {
        this.getDelegate().executeBuild(operationParameters, operationParameters);
    }
}

