/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.internal.build.VersionOnlyBuildEnvironment;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.converters.GradleProjectConverter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.gradle.DefaultGradleProject;
import org.gradle.tooling.internal.protocol.eclipse.EclipseProjectVersion3;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelProvider {
    public <T> T provide(ConsumerConnection connection, Class<T> modelType, ConsumerOperationParameters operationParameters) {
        VersionDetails version = connection.getVersionDetails();
        if (operationParameters.getJavaHome() != null && !version.supportsConfiguringJavaHome()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setJavaHome() and buildLauncher.setJavaHome()");
        }
        if (operationParameters.getJvmArguments() != null && !version.supportsConfiguringJvmArguments()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setJvmArguments() and buildLauncher.setJvmArguments()");
        }
        if (operationParameters.getStandardInput() != null && !version.supportsConfiguringStandardInput()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.setStandardInput() and buildLauncher.setStandardInput()");
        }
        if (modelType != Void.class && operationParameters.getTasks() != null && !version.supportsRunningTasksWhenBuildingModel()) {
            throw Exceptions.unsupportedOperationConfiguration("modelBuilder.forTasks()");
        }
        if (modelType == BuildEnvironment.class && !version.isModelSupported(BuildEnvironment.class)) {
            VersionOnlyBuildEnvironment out = new VersionOnlyBuildEnvironment(version.getVersion());
            return modelType.cast(out);
        }
        if (modelType == GradleProject.class && !version.isModelSupported(GradleProject.class)) {
            EclipseProjectVersion3 project = connection.run(EclipseProjectVersion3.class, operationParameters);
            DefaultGradleProject gradleProject = new GradleProjectConverter().convert(project);
            return modelType.cast(gradleProject);
        }
        if (!version.isModelSupported(modelType)) {
            throw new UnknownModelException(String.format("The version of Gradle you are using (%s) does not support building a model of type '%s'.", version.getVersion(), modelType.getSimpleName()));
        }
        return connection.run(modelType, operationParameters);
    }
}

