/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.ResultHandlerAdapter;
import org.gradle.tooling.internal.consumer.async.AsyncConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.model.UnsupportedMethodException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelBuilder<T>
implements ModelBuilder<T> {
    private final Class<T> modelType;
    private final AsyncConnection connection;
    private ConsumerOperationParameters operationParameters;

    public DefaultModelBuilder(Class<T> modelType, AsyncConnection connection, ConnectionParameters parameters) {
        this.operationParameters = new ConsumerOperationParameters(parameters);
        this.modelType = modelType;
        this.connection = connection;
    }

    @Override
    public T get() throws GradleConnectionException {
        BlockingResultHandler<T> handler = new BlockingResultHandler<T>(this.modelType);
        this.get(handler);
        return handler.getResult();
    }

    @Override
    public void get(ResultHandler<? super T> handler) throws IllegalStateException {
        this.connection.run(this.modelType, this.operationParameters, new ResultHandlerAdapter<T>(handler){

            @Override
            protected String connectionFailureMessage(Throwable failure) {
                String message = String.format("Could not fetch model of type '%s' using %s.", DefaultModelBuilder.this.modelType.getSimpleName(), DefaultModelBuilder.this.connection.getDisplayName());
                if (!(failure instanceof UnsupportedMethodException) && failure instanceof UnsupportedOperationException) {
                    message = message + "\nMost likely the model of that type is not supported in the target Gradle version.\nTo resolve the problem you can change/upgrade the Gradle version the tooling api connects to.";
                }
                return message;
            }
        });
    }

    @Override
    public DefaultModelBuilder<T> withArguments(String ... arguments) {
        this.operationParameters.setArguments(arguments);
        return this;
    }

    @Override
    public DefaultModelBuilder<T> setStandardOutput(OutputStream outputStream) {
        this.operationParameters.setStandardOutput(outputStream);
        return this;
    }

    @Override
    public DefaultModelBuilder<T> setStandardError(OutputStream outputStream) {
        this.operationParameters.setStandardError(outputStream);
        return this;
    }

    @Override
    public DefaultModelBuilder<T> setStandardInput(InputStream inputStream) {
        this.operationParameters.setStandardInput(inputStream);
        return this;
    }

    @Override
    public DefaultModelBuilder<T> setJavaHome(File javaHome) {
        this.operationParameters.setJavaHome(javaHome);
        return this;
    }

    @Override
    public DefaultModelBuilder<T> setJvmArguments(String ... jvmArguments) {
        this.operationParameters.setJvmArguments(jvmArguments);
        return this;
    }

    @Override
    public DefaultModelBuilder<T> addProgressListener(ProgressListener listener) {
        this.operationParameters.addProgressListener(listener);
        return this;
    }

    @Override
    public DefaultModelBuilder<T> forTasks(String ... tasks) {
        this.operationParameters.setTasks(Arrays.asList(tasks));
        return this;
    }
}

