/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.ResultHandlerAdapter;
import org.gradle.tooling.internal.consumer.async.AsyncConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.model.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBuildLauncher
implements BuildLauncher {
    private final AsyncConnection connection;
    private ConsumerOperationParameters operationParameters;

    public DefaultBuildLauncher(AsyncConnection connection, ConnectionParameters parameters) {
        this.operationParameters = new ConsumerOperationParameters(parameters);
        this.operationParameters.setTasks(Collections.<String>emptyList());
        this.connection = connection;
    }

    @Override
    public BuildLauncher forTasks(String ... tasks) {
        this.operationParameters.setTasks(Arrays.asList(tasks));
        return this;
    }

    @Override
    public BuildLauncher forTasks(Task ... tasks) {
        this.forTasks(Arrays.asList(tasks));
        return this;
    }

    @Override
    public BuildLauncher forTasks(Iterable<? extends Task> tasks) {
        ArrayList<String> taskPaths = new ArrayList<String>();
        for (Task task : tasks) {
            taskPaths.add(task.getPath());
        }
        this.operationParameters.setTasks(taskPaths);
        return this;
    }

    @Override
    public BuildLauncher withArguments(String ... arguments) {
        this.operationParameters.setArguments(arguments);
        return this;
    }

    @Override
    public DefaultBuildLauncher setStandardError(OutputStream outputStream) {
        this.operationParameters.setStandardError(outputStream);
        return this;
    }

    @Override
    public DefaultBuildLauncher setStandardOutput(OutputStream outputStream) {
        this.operationParameters.setStandardOutput(outputStream);
        return this;
    }

    @Override
    public DefaultBuildLauncher setStandardInput(InputStream inputStream) {
        this.operationParameters.setStandardInput(inputStream);
        return this;
    }

    @Override
    public DefaultBuildLauncher setJavaHome(File javaHome) {
        this.operationParameters.setJavaHome(javaHome);
        return this;
    }

    @Override
    public DefaultBuildLauncher setJvmArguments(String ... jvmArguments) {
        this.operationParameters.setJvmArguments(jvmArguments);
        return this;
    }

    @Override
    public DefaultBuildLauncher addProgressListener(ProgressListener listener) {
        this.operationParameters.addProgressListener(listener);
        return this;
    }

    @Override
    public void run() {
        BlockingResultHandler<Void> handler = new BlockingResultHandler<Void>(Void.class);
        this.run(handler);
        handler.getResult();
    }

    @Override
    public void run(ResultHandler<? super Void> handler) {
        this.connection.run(Void.class, this.operationParameters, new ResultHandlerAdapter<Void>(handler){

            @Override
            protected String connectionFailureMessage(Throwable failure) {
                return String.format("Could not execute build using %s.", DefaultBuildLauncher.this.connection.getDisplayName());
            }
        });
    }
}

