/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.internal.SystemProperties;
import org.gradle.util.GFileUtils;

public class BuildLayoutParameters {
    private boolean searchUpwards = true;
    private File projectDir = GFileUtils.canonicalise(SystemProperties.getCurrentDir());
    private File gradleUserHomeDir;

    public BuildLayoutParameters() {
        String gradleUserHome = System.getProperty("gradle.user.home");
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = StartParameter.DEFAULT_GRADLE_USER_HOME.getAbsolutePath();
        }
        this.gradleUserHomeDir = GFileUtils.canonicalise(new File(gradleUserHome));
    }

    public BuildLayoutParameters setSearchUpwards(boolean searchUpwards) {
        this.searchUpwards = searchUpwards;
        return this;
    }

    public BuildLayoutParameters setProjectDir(File projectDir) {
        this.projectDir = projectDir;
        return this;
    }

    public BuildLayoutParameters setGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        return this;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public boolean getSearchUpwards() {
        return this.searchUpwards;
    }
}

